/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.AbstractBaseRepository;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.QualifiedResource;
import de.shadowhunt.subversion.internal.Resolve;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class ResolveOperation
extends AbstractOperation<Optional<QualifiedResource>> {
    private final AbstractBaseRepository.ResourceMapper config;
    private final Revision expected;
    private final QualifiedResource resource;
    private final Revision revision;

    ResolveOperation(URI repository, QualifiedResource resource, Revision revision, Revision expected, AbstractBaseRepository.ResourceMapper config) {
        super(repository);
        this.resource = resource;
        this.revision = revision;
        this.expected = expected;
        this.config = config;
    }

    @Override
    protected HttpUriRequest createRequest() {
        StringBuilderWriter body = new StringBuilderWriter();
        try {
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter((Writer)body);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("get-locations");
            writer.writeDefaultNamespace("svn:");
            writer.writeEmptyElement("path");
            writer.writeStartElement("peg-revision");
            writer.writeCharacters(this.revision.toString());
            writer.writeEndElement();
            writer.writeStartElement("location-revision");
            writer.writeCharacters(this.expected.toString());
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new SubversionException("could not create request body", e);
        }
        URI uri = URIUtils.appendResources(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("REPORT", uri);
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 200 == statusCode || 404 == statusCode;
    }

    @Override
    protected Optional<QualifiedResource> processResponse(HttpResponse response) throws IOException {
        int statusCode = ResolveOperation.getStatusCode(response);
        if (statusCode == 404) {
            return Optional.empty();
        }
        Resolve resolve = Resolve.read(ResolveOperation.getContent(response));
        return Optional.of(this.config.getVersionedResource(new QualifiedResource(resolve.getResource()), this.expected));
    }
}

