/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Repository;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.Probe;
import de.shadowhunt.subversion.xml.AbstractSaxExpression;
import de.shadowhunt.subversion.xml.AbstractSaxExpressionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

final class ProbeReader {
    static Probe read(InputStream inputStream, Repository.ProtocolVersion version) throws IOException {
        try {
            ProbeHandler handler = new ProbeHandler(version);
            Optional probe = handler.parse(inputStream);
            return (Probe)probe.orElseThrow(() -> new SubversionException("Invalid server response: could not be parsed"));
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new SubversionException("Invalid server response: could not parse response", e);
        }
    }

    private ProbeReader() {
    }

    private static class ProbeHandler
    extends AbstractSaxExpressionHandler<Probe> {
        ProbeHandler(Repository.ProtocolVersion version) {
            super(new CollectionExpression(version));
        }

        @Override
        public Optional<Probe> getValue() {
            return ((CollectionExpression)this.expressions[0]).getValue();
        }
    }

    private static class CollectionExpression
    extends AbstractSaxExpression<Probe> {
        private static final QName[] PATH = new QName[]{new QName("DAV:", "options-response"), new QName("DAV:", "activity-collection-set"), new QName("DAV:", "href")};
        private static final Pattern PATH_PATTERN = Pattern.compile("/");
        private Probe probe;
        private final Repository.ProtocolVersion version;

        CollectionExpression(Repository.ProtocolVersion version) {
            super(PATH);
            this.version = version;
        }

        @Override
        public Optional<Probe> getValue() {
            return Optional.ofNullable(this.probe);
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            if (Repository.ProtocolVersion.HTTP_V1 == this.version || Repository.ProtocolVersion.HTTP_V2 == this.version) {
                String[] segments = PATH_PATTERN.split(text);
                int prefixIndex = segments.length - 2;
                Resource prefix = Resource.create(segments[prefixIndex]);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < prefixIndex; ++i) {
                    sb.append('/');
                    sb.append(segments[i]);
                }
                Resource basePath = Resource.create(sb.toString());
                this.probe = new Probe(basePath, prefix);
            }
        }

        @Override
        public void resetHandler() {
            super.resetHandler();
            this.probe = null;
        }
    }
}

