/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.internal.URIUtils;
import java.net.URI;

public class Probe {
    private final Resource basePath;
    private final Resource prefix;

    Probe(Resource basePath, Resource prefix) {
        this.basePath = basePath;
        this.prefix = prefix;
    }

    public Resource getBasePath() {
        return this.basePath;
    }

    public Resource getBasePath(URI server) {
        String completePath = server.getPath();
        String repoPath = this.getBaseUri(server).getPath();
        String suffix = completePath.substring(repoPath.length());
        return Resource.create(suffix);
    }

    public URI getBaseUri(URI server) {
        return URIUtils.replacePathWithResources(server, this.basePath);
    }

    public Resource getPrefix() {
        return this.prefix;
    }
}

