/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Log;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.LogImplReader;
import de.shadowhunt.subversion.internal.QualifiedResource;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class LogOperation
extends AbstractOperation<List<Log>> {
    private final Revision end;
    private final int limit;
    private final QualifiedResource resource;
    private final Revision start;
    private final boolean stopOnCopy;

    LogOperation(URI repository, QualifiedResource resource, Revision start, Revision end, int limit, boolean stopOnCopy) {
        super(repository);
        this.resource = resource;
        this.start = start;
        this.end = end;
        this.limit = limit;
        this.stopOnCopy = stopOnCopy;
    }

    @Override
    protected HttpUriRequest createRequest() {
        StringBuilderWriter body = new StringBuilderWriter();
        try {
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter((Writer)body);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("log-report");
            writer.writeDefaultNamespace("svn:");
            writer.writeStartElement("start-revision");
            writer.writeCharacters(this.start.toString());
            writer.writeEndElement();
            writer.writeStartElement("end-revision");
            writer.writeCharacters(this.end.toString());
            writer.writeEndElement();
            if (this.stopOnCopy) {
                writer.writeEmptyElement("strict-node-history");
            }
            if (this.limit > 0) {
                writer.writeStartElement("limit");
                writer.writeCharacters(Integer.toString(this.limit));
                writer.writeEndElement();
            }
            writer.writeEmptyElement("discover-changed-paths");
            writer.writeEmptyElement("all-revprops");
            writer.writeEmptyElement("path");
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new SubversionException("could not create request body", e);
        }
        URI uri = URIUtils.appendResources(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("REPORT", uri);
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 200 == statusCode;
    }

    @Override
    protected List<Log> processResponse(HttpResponse response) throws IOException {
        return LogImplReader.read(LogOperation.getContent(response));
    }
}

