/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;

final class DateUtils {
    private static final FastDateFormat CREATED;
    private static final FastDateFormat LAST_MODIFIED;

    static Date parseCreatedDate(String date) {
        int lastIndex = date.length() - 1;
        if ('Z' != date.charAt(lastIndex)) {
            throw new IllegalArgumentException("date '" + date + "'is not in Zulu timezone");
        }
        int index = date.indexOf(46);
        String time = index > 0 ? date.substring(0, index + 4) : date.substring(0, lastIndex) + ".000";
        try {
            return CREATED.parse(time);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("given date '" + date + "' can not be parsed", e);
        }
    }

    static Date parseLastModifiedDate(String date) {
        try {
            return LAST_MODIFIED.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("given date '" + date + "' can not be parsed", e);
        }
    }

    private DateUtils() {
    }

    static {
        TimeZone zulu = TimeZone.getTimeZone("ZULU");
        CREATED = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (TimeZone)zulu, (Locale)Locale.US);
        LAST_MODIFIED = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'", (TimeZone)zulu, (Locale)Locale.US);
    }
}

