/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.InfoOperation;
import de.shadowhunt.subversion.internal.QualifiedResource;
import de.shadowhunt.subversion.internal.RepositoryLocator;
import java.net.URI;
import java.util.Optional;
import java.util.UUID;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;

public abstract class AbstractRepositoryLocator
implements RepositoryLocator {
    private static final ResourceProperty.Key[] REPOSITORY_UUID = new ResourceProperty.Key[]{ResourceProperty.REPOSITORY_ID};

    protected static UUID determineRepositoryId(URI repository, Resource prefix, HttpClient client, HttpContext context) {
        InfoOperation operation = new InfoOperation(repository, Resource.ROOT, new QualifiedResource(Resource.ROOT), prefix, REPOSITORY_UUID);
        Optional info = (Optional)operation.execute(client, context);
        return ((Info)info.orElseThrow(() -> new SubversionException("No repository found at " + repository, 400))).getRepositoryId();
    }
}

