/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Depth;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.QualifiedResource;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

abstract class AbstractPropfindOperation<T>
extends AbstractOperation<T> {
    protected final Depth depth;
    protected final Resource marker;
    protected final ResourceProperty.Key[] propertyKeys;
    protected final QualifiedResource resource;

    private static boolean contains(ResourceProperty.Key[] propertyKeys, String namespace) {
        for (ResourceProperty.Key requestedProperty : propertyKeys) {
            if (!namespace.equals(requestedProperty.getType().getPrefix())) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    private static ResourceProperty.Key[] filter(ResourceProperty.Key[] keys) {
        if (keys == null) {
            return null;
        }
        int w = 0;
        int r = 0;
        while (r < keys.length) {
            if (ResourceProperty.Type.SUBVERSION_CUSTOM.equals((Object)keys[r].getType())) {
                ++r;
                continue;
            }
            keys[w++] = keys[r++];
        }
        return Arrays.copyOf(keys, w);
    }

    AbstractPropfindOperation(URI repository, QualifiedResource resource, Resource marker, Depth depth) {
        super(repository);
        this.resource = resource;
        this.marker = marker;
        this.depth = depth;
        this.propertyKeys = null;
    }

    AbstractPropfindOperation(URI repository, QualifiedResource resource, Resource marker, Depth depth, ResourceProperty.Key[] propertyKeys) {
        super(repository);
        this.resource = resource;
        this.marker = marker;
        this.depth = depth;
        this.propertyKeys = AbstractPropfindOperation.filter(propertyKeys);
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.appendResources(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("PROPFIND", uri);
        request.addHeader("Depth", this.depth.value);
        StringBuilderWriter body = new StringBuilderWriter();
        try {
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter((Writer)body);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("propfind");
            writer.writeDefaultNamespace("DAV:");
            if (this.propertyKeys != null) {
                if (this.propertyKeys.length == 0) {
                    writer.writeEmptyElement("allprop");
                } else {
                    writer.writeStartElement("prop");
                    if (AbstractPropfindOperation.contains(this.propertyKeys, "http://subversion.tigris.org/xmlns/dav/")) {
                        writer.writeNamespace("V", "http://subversion.tigris.org/xmlns/dav/");
                        writer.setPrefix("V", "http://subversion.tigris.org/xmlns/dav/");
                    }
                    if (AbstractPropfindOperation.contains(this.propertyKeys, "http://subversion.tigris.org/xmlns/svn/")) {
                        writer.writeNamespace("S", "http://subversion.tigris.org/xmlns/svn/");
                        writer.setPrefix("S", "http://subversion.tigris.org/xmlns/svn/");
                    }
                    for (ResourceProperty.Key requestedProperty : this.propertyKeys) {
                        writer.writeEmptyElement(requestedProperty.getType().getPrefix(), requestedProperty.getName());
                    }
                    writer.writeEndElement();
                }
            } else {
                writer.writeEmptyElement("prop");
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new SubversionException("could not create request body", e);
        }
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 207 == statusCode || 404 == statusCode;
    }
}

