/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion;

import java.io.Serializable;
import org.apache.commons.lang3.Validate;

public final class Revision
implements Comparable<Revision>,
Serializable {
    public static final Revision EMPTY = new Revision(0L);
    public static final Revision HEAD = new Revision(Long.MAX_VALUE);
    public static final Revision INITIAL = new Revision(1L);
    private static final long serialVersionUID = 1L;
    private final long version;

    public static Revision create(int revision) {
        Validate.isTrue((revision >= 0 ? 1 : 0) != 0, (String)"Value must be greater or equal than 0, was {0}", (long)revision);
        switch (revision) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return INITIAL;
            }
        }
        return new Revision(revision);
    }

    private Revision(long revision) {
        this.version = revision;
    }

    @Override
    public int compareTo(Revision other) {
        return Long.compare(this.version, other.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Revision)) {
            return false;
        }
        Revision revision = (Revision)o;
        return this.version == revision.version;
    }

    public int hashCode() {
        return (int)(this.version ^ this.version >>> 32);
    }

    public String toString() {
        if (this.version == Revision.HEAD.version) {
            return "HEAD";
        }
        return Long.toString(this.version);
    }
}

