/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion;

import de.shadowhunt.subversion.Depth;
import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Log;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.Transaction;
import de.shadowhunt.subversion.View;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface Repository {
    public void add(Transaction var1, Resource var2, boolean var3, InputStream var4);

    public void commit(Transaction var1, String var2, boolean var3);

    public void copy(Transaction var1, Resource var2, Revision var3, Resource var4, boolean var5);

    public Transaction createTransaction();

    public View createView();

    public void delete(Transaction var1, Resource var2);

    public InputStream download(Resource var1, Revision var2);

    public InputStream download(View var1, Resource var2, Revision var3);

    public URI downloadURI(Resource var1, Revision var2);

    public URI downloadURI(View var1, Resource var2, Revision var3);

    public boolean exists(Resource var1, Revision var2);

    public boolean exists(View var1, Resource var2, Revision var3);

    public Resource getBasePath();

    public URI getBaseUri();

    public ProtocolVersion getProtocolVersion();

    public UUID getRepositoryId();

    public Info info(Resource var1, Revision var2, ResourceProperty.Key ... var3);

    public Info info(View var1, Resource var2, Revision var3, ResourceProperty.Key ... var4);

    public Set<Info> list(Resource var1, Revision var2, Depth var3, ResourceProperty.Key ... var4);

    public Set<Info> list(View var1, Resource var2, Revision var3, Depth var4, ResourceProperty.Key ... var5);

    public void lock(Resource var1, boolean var2);

    public List<Log> log(Resource var1, Revision var2, Revision var3, int var4, boolean var5);

    public List<Log> log(View var1, Resource var2, Revision var3, Revision var4, int var5, boolean var6);

    public void mkdir(Transaction var1, Resource var2, boolean var3);

    public void move(Transaction var1, Resource var2, Resource var3, boolean var4);

    public void propertiesDelete(Transaction var1, Resource var2, ResourceProperty ... var3);

    public void propertiesSet(Transaction var1, Resource var2, ResourceProperty ... var3);

    public void rollback(Transaction var1);

    public void rollbackIfNotCommitted(Transaction var1);

    public void unlock(Resource var1, boolean var2);

    public static enum ProtocolVersion {
        HTTP_V1,
        HTTP_V2;

    }
}

