/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal.httpv2;

import de.shadowhunt.subversion.Repository;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.internal.AbstractRepositoryLocator;
import de.shadowhunt.subversion.internal.Probe;
import de.shadowhunt.subversion.internal.httpv2.RepositoryImpl;
import java.net.URI;
import java.util.UUID;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;

public class RepositoryLocatorImpl
extends AbstractRepositoryLocator {
    @Override
    public Repository create(URI uri, Probe probe, HttpClient client, HttpContext context) {
        URI repository = probe.getBaseUri(uri);
        Resource base = probe.getBasePath(uri);
        Resource prefix = probe.getPrefix();
        UUID id = RepositoryLocatorImpl.determineRepositoryId(uri, prefix, client, context);
        return new RepositoryImpl(repository, base, id, prefix, client, context);
    }

    @Override
    public boolean isSupported(Repository.ProtocolVersion version) {
        return Repository.ProtocolVersion.HTTP_V2 == version;
    }
}

