/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.LockToken;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.QualifiedResource;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;

class UploadOperation
extends AbstractVoidOperation {
    private static final long STREAM_WHOLE_CONTENT = -1L;
    private final InputStream content;
    private final Optional<LockToken> lockToken;
    private final QualifiedResource resource;

    UploadOperation(URI repository, QualifiedResource resource, Optional<LockToken> lockToken, InputStream content) {
        super(repository);
        this.resource = resource;
        this.lockToken = lockToken;
        this.content = content;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.appendResources(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("PUT", uri);
        this.lockToken.ifPresent(x -> request.addHeader("If", "<" + uri + "> (<" + x + ">)"));
        request.setEntity((HttpEntity)new InputStreamEntity(this.content, -1L));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 201 == statusCode || 204 == statusCode;
    }
}

