/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.internal.QualifiedResource;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;

public final class URIUtils {
    private static URI appendResource0(URI repository, Resource ... resources) throws URISyntaxException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(repository.getScheme());
        builder.setHost(repository.getHost());
        builder.setPort(repository.getPort());
        StringBuilder completePath = new StringBuilder(repository.getPath());
        for (Resource resource : resources) {
            completePath.append(resource.getValue());
        }
        builder.setPath(completePath.toString());
        return builder.build();
    }

    public static URI appendResources(URI repository, QualifiedResource resource) {
        return URIUtils.appendResources(repository, resource.getBase(), resource.getResource());
    }

    public static URI appendResources(URI repository, Resource ... resources) {
        try {
            return URIUtils.appendResource0(repository, resources);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URI replacePathWithResources(URI repository, Resource ... resources) {
        try {
            return URIUtils.replacePathWithResources0(repository, resources);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static URI replacePathWithResources0(URI repository, Resource ... resources) throws URISyntaxException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(repository.getScheme());
        builder.setHost(repository.getHost());
        builder.setPort(repository.getPort());
        StringBuilder completePath = new StringBuilder();
        for (Resource resource : resources) {
            completePath.append(resource.getValue());
        }
        builder.setPath(completePath.toString());
        return builder.build();
    }

    private URIUtils() {
    }
}

