/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.xml.AbstractSaxExpression;
import de.shadowhunt.subversion.xml.AbstractSaxExpressionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

final class Resolve {
    private final Resource resource;
    private final Revision revision;

    static Resolve read(InputStream inputStream) throws IOException {
        Optional resolve;
        ResolveHandler handler = new ResolveHandler();
        try {
            resolve = handler.parse(inputStream);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new SubversionException("Invalid server response: could not parse response", e);
        }
        return (Resolve)resolve.orElseThrow(() -> new SubversionException("Invalid server response: could not parse response"));
    }

    private Resolve(Resource resource, Revision revision) {
        this.resource = resource;
        this.revision = revision;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resolve other = (Resolve)obj;
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
    }

    public Resource getResource() {
        return this.resource;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Resolve [resource=");
        builder.append(this.resource);
        builder.append(", revision=");
        builder.append(this.revision);
        builder.append(']');
        return builder.toString();
    }

    private static class ResolveHandler
    extends AbstractSaxExpressionHandler<Resolve> {
        ResolveHandler() {
            super(new ResolveExpression());
        }

        @Override
        public Optional<Resolve> getValue() {
            return ((ResolveExpression)this.expressions[0]).getValue();
        }
    }

    private static class ResolveExpression
    extends AbstractSaxExpression<Resolve> {
        private static final QName[] PATH = new QName[]{new QName("svn:", "get-locations-report"), new QName("svn:", "location")};
        private Resolve entry;

        ResolveExpression() {
            super(PATH);
        }

        @Override
        public Optional<Resolve> getValue() {
            return Optional.ofNullable(this.entry);
        }

        @Override
        protected void processStart(String nameSpaceUri, String localName, Attributes attributes) {
            String path = attributes.getValue("path");
            Resource resource = Resource.create(path);
            String version = attributes.getValue("rev");
            Revision revision = Revision.create(Integer.parseInt(version));
            this.entry = new Resolve(resource, revision);
        }

        @Override
        public void resetHandler() {
            super.resetHandler();
            this.entry = null;
        }
    }
}

