/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Log;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.DateUtils;
import de.shadowhunt.subversion.internal.LogImpl;
import de.shadowhunt.subversion.xml.AbstractSaxExpression;
import de.shadowhunt.subversion.xml.AbstractSaxExpressionHandler;
import de.shadowhunt.subversion.xml.SaxExpression;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

final class LogImplReader {
    static List<Log> read(InputStream inputStream) throws IOException {
        LogHandler handler = new LogHandler();
        try {
            Optional logs = handler.parse(inputStream);
            return (List)logs.get();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new SubversionException("Invalid server response: could not parse response", e);
        }
    }

    private LogImplReader() {
    }

    private static class RevisionExpression
    extends AbstractSaxExpression<Revision> {
        public static final QName[] PATH = new QName[]{new QName("DAV:", "version-name")};
        private Optional<Revision> revision = Optional.empty();

        RevisionExpression() {
            super(PATH);
        }

        @Override
        public Optional<Revision> getValue() {
            return this.revision;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            int version = Integer.parseInt(text);
            this.revision = Optional.of(Revision.create(version));
        }

        @Override
        public void resetHandler() {
            this.revision = Optional.empty();
        }
    }

    private static class LogHandler
    extends AbstractSaxExpressionHandler<List<Log>> {
        LogHandler() {
            super(new LogExpression());
        }

        @Override
        public Optional<List<Log>> getValue() {
            LogExpression expression = (LogExpression)this.expressions[0];
            Optional<List<Log>> logs = expression.getValue();
            expression.clear();
            return logs;
        }
    }

    private static class LogExpression
    extends AbstractSaxExpression<List<Log>> {
        private static final QName[] PATH = new QName[]{new QName("svn:", "log-report"), new QName("svn:", "log-item")};
        private List<Log> entries = new ArrayList<Log>();

        private static SaxExpression<?>[] createExpressions() {
            return new SaxExpression[]{new CommentExpression(), new CreatorExpression(), new DateExpression(), new RevisionExpression()};
        }

        LogExpression() {
            super(PATH, LogExpression.createExpressions());
        }

        @Override
        public void clear() {
            this.entries = new ArrayList<Log>();
        }

        @Override
        public Optional<List<Log>> getValue() {
            return Optional.of(this.entries);
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            LogImpl log = new LogImpl();
            log.setMessage(((CommentExpression)this.children[0]).getValue().get());
            log.setAuthor(((CreatorExpression)this.children[1]).getValue().get());
            log.setDate(((DateExpression)this.children[2]).getValue().get());
            log.setRevision(((RevisionExpression)this.children[3]).getValue().get());
            this.entries.add(log);
        }
    }

    private static class DateExpression
    extends AbstractSaxExpression<Date> {
        public static final QName[] PATH = new QName[]{new QName("svn:", "date")};
        private Optional<Date> date = Optional.empty();

        DateExpression() {
            super(PATH);
        }

        @Override
        public Optional<Date> getValue() {
            return this.date;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            this.date = Optional.of(DateUtils.parseCreatedDate(text));
        }

        @Override
        public void resetHandler() {
            this.date = Optional.empty();
        }
    }

    private static class CreatorExpression
    extends AbstractSaxExpression<String> {
        private static final QName[] PATH = new QName[]{new QName("DAV:", "creator-displayname")};
        private Optional<String> creator = Optional.empty();

        CreatorExpression() {
            super(PATH);
        }

        @Override
        public Optional<String> getValue() {
            return this.creator;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            this.creator = Optional.of(text);
        }

        @Override
        public void resetHandler() {
            this.creator = Optional.empty();
        }
    }

    private static class CommentExpression
    extends AbstractSaxExpression<String> {
        private static final Optional<String> EMPTY = Optional.of("");
        private static final QName[] PATH = new QName[]{new QName("DAV:", "comment")};
        private Optional<String> comment = EMPTY;

        CommentExpression() {
            super(PATH);
        }

        @Override
        public Optional<String> getValue() {
            return this.comment;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            this.comment = Optional.of(text);
        }

        @Override
        public void resetHandler() {
            this.comment = EMPTY;
        }
    }
}

