/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.LockToken;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.DateUtils;
import de.shadowhunt.subversion.internal.InfoImpl;
import de.shadowhunt.subversion.internal.ResourcePropertyUtils;
import de.shadowhunt.subversion.xml.AbstractSaxExpression;
import de.shadowhunt.subversion.xml.AbstractSaxExpressionHandler;
import de.shadowhunt.subversion.xml.SaxExpression;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

final class InfoImplReader {
    static Info read(InputStream in, Resource basePath) throws IOException {
        List<Info> infoSet = InfoImplReader.readAll(in, basePath);
        if (infoSet.isEmpty()) {
            throw new SubversionException("Invalid server response: expected content is missing");
        }
        return infoSet.get(0);
    }

    static List<Info> readAll(InputStream inputStream, Resource basePath) throws IOException {
        InfoHandler handler = new InfoHandler(basePath);
        try {
            InputStream escapedStream = ResourcePropertyUtils.escapedInputStream(inputStream);
            Optional list = handler.parse(escapedStream);
            return (List)list.get();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new SubversionException("Invalid server response: could not parse response", e);
        }
    }

    private InfoImplReader() {
    }

    private static class StringExpression
    extends AbstractSaxExpression<String> {
        private static final QName PROP = new QName("DAV:", "prop");
        private static final QName PROPSTAT = new QName("DAV:", "propstat");
        private Optional<String> value = Optional.empty();

        private static QName[] prefix(QName ... path) {
            QName[] prefixPath = new QName[path.length + 2];
            int i = 0;
            prefixPath[i++] = PROPSTAT;
            prefixPath[i++] = PROP;
            for (QName name : path) {
                prefixPath[i++] = name;
            }
            return prefixPath;
        }

        protected StringExpression(QName ... path) {
            super(StringExpression.prefix(path));
        }

        @Override
        public Optional<String> getValue() {
            return this.value;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            this.value = Optional.ofNullable(text);
        }

        @Override
        public void resetHandler() {
            this.value = Optional.empty();
        }
    }

    private static class StatusExpression
    extends AbstractSaxExpression<Void> {
        public static final QName[] PATH = new QName[]{new QName("DAV:", "propstat"), new QName("DAV:", "status")};

        StatusExpression() {
            super(PATH);
        }

        @Override
        public Optional<Void> getValue() {
            throw new UnsupportedOperationException("no value available");
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            if (!"HTTP/1.1 200 OK".equals(text)) {
                throw new SubversionException("properties are missing");
            }
        }
    }

    private static class ResourceTypeExpression
    extends AbstractSaxExpression<Boolean> {
        private static final QName[] PATH = new QName[]{new QName("DAV:", "propstat"), new QName("DAV:", "prop"), new QName("DAV:", "resourcetype"), new QName("DAV:", "collection")};
        private boolean folder = false;

        protected ResourceTypeExpression() {
            super(PATH);
        }

        @Override
        public Optional<Boolean> getValue() {
            return Optional.of(this.folder);
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            this.folder = true;
        }

        @Override
        public void resetHandler() {
            this.folder = false;
        }
    }

    private static class ResourceExpression
    extends AbstractSaxExpression<Resource> {
        private static final QName[] PATH = new QName[]{new QName("DAV:", "propstat"), new QName("DAV:", "prop"), new QName("http://subversion.tigris.org/xmlns/dav/", "baseline-relative-path")};
        private final Resource basePath;
        private Optional<Resource> resource = Optional.empty();

        ResourceExpression(Resource basePath) {
            super(PATH);
            this.basePath = basePath;
        }

        @Override
        public Optional<Resource> getValue() {
            return this.resource;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            Resource qualifiedResource = Resource.create(text);
            String relative = StringUtils.removeStart((String)qualifiedResource.getValue(), (String)this.basePath.getValue());
            this.resource = Optional.of(Resource.create(relative));
        }

        @Override
        public void resetHandler() {
            this.resource = Optional.empty();
        }
    }

    private static class PropertyExpression
    extends AbstractSaxExpression<ResourceProperty[]> {
        private static final QName[] PATH = new QName[]{new QName("DAV:", "propstat"), new QName("DAV:", "prop"), new QName("", "*")};
        private Set<ResourceProperty> properties = new TreeSet<ResourceProperty>(ResourceProperty.TYPE_NAME_COMPARATOR);

        PropertyExpression() {
            super(PATH);
        }

        @Override
        public void clear() {
            this.properties = new TreeSet<ResourceProperty>(ResourceProperty.TYPE_NAME_COMPARATOR);
        }

        @Override
        public Optional<ResourceProperty[]> getValue() {
            ResourceProperty[] resourceProperties = new ResourceProperty[this.properties.size()];
            int i = 0;
            for (ResourceProperty property : this.properties) {
                resourceProperties[i++] = property;
            }
            return Optional.of(resourceProperties);
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            String propertyName = ResourcePropertyUtils.unescapedKeyNameXml(localName);
            if ("http://subversion.tigris.org/xmlns/custom/".equals(nameSpaceUri)) {
                this.properties.add(new ResourceProperty(ResourceProperty.Type.SUBVERSION_CUSTOM, propertyName, text));
                return;
            }
            if ("http://subversion.tigris.org/xmlns/svn/".equals(nameSpaceUri)) {
                this.properties.add(new ResourceProperty(ResourceProperty.Type.SUBVERSION_SVN, propertyName, text));
                return;
            }
        }
    }

    private static class InfoHandler
    extends AbstractSaxExpressionHandler<List<Info>> {
        InfoHandler(Resource basePath) {
            super(new InfoExpression(basePath));
        }

        @Override
        public Optional<List<Info>> getValue() {
            return ((InfoExpression)this.expressions[0]).getValue();
        }
    }

    private static class InfoExpression
    extends AbstractSaxExpression<List<Info>> {
        private static final QName[] PATH = new QName[]{new QName("DAV:", "multistatus"), new QName("DAV:", "response")};
        private final List<Info> entries = new ArrayList<Info>();

        private static SaxExpression<?>[] createExpressions(Resource basePath) {
            return new SaxExpression[]{new StringExpression(new QName("DAV:", "creationdate")), new ResourceTypeExpression(), new StringExpression(new QName("DAV:", "getlastmodified")), new StringExpression(new QName("DAV:", "lockdiscovery"), new QName("DAV:", "activelock"), new QName("DAV:", "locktoken"), new QName("DAV:", "href")), new StringExpression(new QName("http://subversion.tigris.org/xmlns/dav/", "md5-checksum")), new PropertyExpression(), new StringExpression(new QName("http://subversion.tigris.org/xmlns/dav/", "repository-uuid")), new ResourceExpression(basePath), new StringExpression(new QName("DAV:", "version-name")), new StatusExpression()};
        }

        InfoExpression(Resource basePath) {
            super(PATH, InfoExpression.createExpressions(basePath));
        }

        @Override
        public Optional<List<Info>> getValue() {
            return Optional.of(this.entries);
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            InfoImpl info = new InfoImpl();
            Optional<String> creationDate = ((StringExpression)this.children[0]).getValue();
            creationDate.ifPresent(x -> info.setCreationDate(DateUtils.parseCreatedDate(x)));
            info.setDirectory(((ResourceTypeExpression)this.children[1]).getValue().get());
            Optional<String> modificationDate = ((StringExpression)this.children[2]).getValue();
            modificationDate.ifPresent(x -> info.setLastModifiedDate(DateUtils.parseLastModifiedDate(x)));
            Optional<String> token = ((StringExpression)this.children[3]).getValue();
            token.ifPresent(x -> info.setLockToken(new LockToken((String)x)));
            Optional<String> hash = ((StringExpression)this.children[4]).getValue();
            hash.ifPresent(info::setMd5);
            info.setProperties(((PropertyExpression)this.children[5]).getValue().get());
            Optional<String> uuid = ((StringExpression)this.children[6]).getValue();
            uuid.ifPresent(x -> info.setRepositoryId(UUID.fromString(x)));
            Optional<Resource> resource = ((ResourceExpression)this.children[7]).getValue();
            resource.ifPresent(info::setResource);
            Optional<String> revision = ((StringExpression)this.children[8]).getValue();
            revision.ifPresent(x -> info.setRevision(Revision.create(Integer.parseInt(x))));
            this.entries.add(info);
            this.children[5].clear();
        }
    }
}

