/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Depth;
import de.shadowhunt.subversion.LockToken;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.QualifiedResource;
import de.shadowhunt.subversion.internal.URIUtils;
import java.net.URI;
import java.util.Optional;
import org.apache.http.client.methods.HttpUriRequest;

class CopyOperation
extends AbstractVoidOperation {
    private final Optional<LockToken> lockToken;
    private final QualifiedResource source;
    private final QualifiedResource target;

    CopyOperation(URI repository, QualifiedResource source, QualifiedResource target, Optional<LockToken> lockToken) {
        super(repository);
        this.source = source;
        this.target = target;
        this.lockToken = lockToken;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI sourceUri = URIUtils.appendResources(this.repository, this.source);
        URI targetUri = URIUtils.appendResources(this.repository, this.target);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("COPY", sourceUri);
        request.addHeader("Destination", targetUri.toASCIIString());
        request.addHeader("Depth", Depth.INFINITY.value);
        request.addHeader("Override", "T");
        this.lockToken.ifPresent(x -> request.addHeader("If", "<" + targetUri + "> (<" + x + ">)"));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 201 == statusCode || 204 == statusCode;
    }
}

