/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Depth;
import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.LockToken;
import de.shadowhunt.subversion.Log;
import de.shadowhunt.subversion.Repository;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.Transaction;
import de.shadowhunt.subversion.View;
import de.shadowhunt.subversion.internal.CopyOperation;
import de.shadowhunt.subversion.internal.CreateFolderOperation;
import de.shadowhunt.subversion.internal.DeleteOperation;
import de.shadowhunt.subversion.internal.DownloadOperation;
import de.shadowhunt.subversion.internal.ExistsOperation;
import de.shadowhunt.subversion.internal.InfoOperation;
import de.shadowhunt.subversion.internal.ListOperation;
import de.shadowhunt.subversion.internal.LockOperation;
import de.shadowhunt.subversion.internal.LogOperation;
import de.shadowhunt.subversion.internal.PropertiesUpdateOperation;
import de.shadowhunt.subversion.internal.QualifiedResource;
import de.shadowhunt.subversion.internal.ResolveOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import de.shadowhunt.subversion.internal.UnlockOperation;
import de.shadowhunt.subversion.internal.UploadOperation;
import de.shadowhunt.subversion.internal.ViewImpl;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang3.Validate;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseRepository
implements Repository {
    private static final ResourceProperty.Key[] LOCKING = new ResourceProperty.Key[]{ResourceProperty.RESOURCE, ResourceProperty.LOCK_STATUS};
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"de.shadowhunt.subversion.Repository");
    private static final ResourceProperty.Key[] REVISION = new ResourceProperty.Key[]{ResourceProperty.RESOURCE, ResourceProperty.VERSION};
    private static final ResourceProperty.Key[] TYPE = new ResourceProperty.Key[]{ResourceProperty.RESOURCE, ResourceProperty.RESOURCE_TYPE};
    protected final Resource base;
    protected final HttpClient client;
    protected final ResourceMapper config;
    protected final HttpContext context;
    protected final URI repository;
    protected final UUID repositoryId;

    protected AbstractBaseRepository(URI repository, Resource base, UUID id, ResourceMapper config, HttpClient client, HttpContext context) {
        Validate.notNull((Object)repository, (String)"repository must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)base, (String)"base must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)id, (String)"id must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)config, (String)"config must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)client, (String)"client must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)context, (String)"context must not be null", (Object[])new Object[0]);
        this.repository = repository;
        this.base = base;
        this.repositoryId = id;
        this.config = config;
        this.client = client;
        this.context = context;
    }

    @Override
    public void add(Transaction transaction, Resource resource, boolean parents, InputStream content) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)content, (String)"content must not be null", (Object[])new Object[0]);
        LOGGER.trace("adding resource {} during transaction {} (parents: {})", new Object[]{resource, transaction.getId(), parents});
        if (parents) {
            this.mkdir(transaction, resource.getParent(), true);
        }
        QualifiedResource qualifiedResource = new QualifiedResource(this.base, resource);
        Optional<Info> info = this.info0(transaction, qualifiedResource, transaction.getHeadRevision(), false, LOCKING);
        Optional<LockToken> lockToken = info.flatMap(Info::getLockToken);
        QualifiedResource uploadResource = this.config.getWorkingResource(transaction).append(qualifiedResource);
        UploadOperation operation = new UploadOperation(this.repository, uploadResource, lockToken, content);
        operation.execute(this.client, this.context);
        if (info.isPresent()) {
            transaction.register(resource, Transaction.Status.MODIFIED);
        } else {
            transaction.register(resource, Transaction.Status.ADDED);
        }
    }

    @Override
    public void copy(Transaction transaction, Resource sourceResource, Revision sourceRevision, Resource targetResource, boolean parents) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)sourceResource, (String)"sourceResource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)sourceRevision, (String)"sourceRevision must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)targetResource, (String)"targetResource must not be null", (Object[])new Object[0]);
        this.validateRevision(transaction, sourceRevision);
        LOGGER.trace("copying resource from {}@{} to {} during transaction {} (parents: {})", new Object[]{sourceResource, sourceRevision, targetResource, transaction.getId(), parents});
        this.copy0(transaction, new QualifiedResource(this.base, sourceResource), sourceRevision, new QualifiedResource(this.base, targetResource), parents, true);
    }

    private void copy0(Transaction transaction, QualifiedResource sourceResource, Revision sourceRevision, QualifiedResource targetResource, boolean parents, boolean resolveSource) {
        if (parents) {
            this.createFolder(transaction, targetResource.getParent(), true);
        } else {
            this.registerResource(transaction, targetResource.getParent().getResource(), transaction.getHeadRevision());
        }
        Optional<Info> sourceInfo = this.info0(transaction, sourceResource, sourceRevision, resolveSource, REVISION);
        Info sourceInfoValue = sourceInfo.orElseThrow(() -> new SubversionException("Can't resolve: " + sourceResource + '@' + sourceRevision));
        Optional<Info> targetInfo = this.info0(transaction, targetResource, transaction.getHeadRevision(), false, LOCKING);
        Optional<LockToken> lockToken = targetInfo.flatMap(Info::getLockToken);
        QualifiedResource source = this.config.getVersionedResource(new QualifiedResource(this.base, sourceInfoValue.getResource()), sourceInfoValue.getRevision());
        QualifiedResource target = this.config.getWorkingResource(transaction).append(targetResource);
        CopyOperation operation = new CopyOperation(this.repository, source, target, lockToken);
        operation.execute(this.client, this.context);
        if (targetInfo.isPresent()) {
            transaction.register(targetResource.getResource(), Transaction.Status.MODIFIED);
        } else {
            transaction.register(targetResource.getResource(), Transaction.Status.ADDED);
        }
    }

    private void createFolder(Transaction transaction, QualifiedResource resource, boolean parents) {
        Revision headRevision = transaction.getHeadRevision();
        Optional<Info> info = this.info0(transaction, resource, headRevision, false, TYPE);
        if (parents && !info.isPresent() && !Resource.ROOT.equals(resource.getResource())) {
            this.createFolder(transaction, resource.getParent(), true);
        }
        if (info.isPresent()) {
            if (info.get().isFile()) {
                throw new SubversionException("Can not create folder. File with same name already exists: " + resource);
            }
            Map<Resource, Transaction.Status> changeSet = transaction.getChangeSet();
            Transaction.Status status = changeSet.get(resource.getResource());
            if (status == null) {
                this.registerResource(transaction, resource.getResource(), headRevision);
            }
        } else {
            QualifiedResource folder = this.config.getWorkingResource(transaction).append(resource);
            CreateFolderOperation operation = new CreateFolderOperation(this.repository, folder);
            operation.execute(this.client, this.context);
            transaction.register(resource.getResource(), Transaction.Status.ADDED);
        }
        QualifiedResource current = resource.getParent();
        while (!Resource.ROOT.equals(current.getResource()) && transaction.register(current.getResource(), Transaction.Status.EXISTS)) {
            current = current.getParent();
        }
    }

    @Override
    public View createView() {
        LOGGER.trace("creating new view");
        Revision headRevision = this.determineHeadRevision();
        return new ViewImpl(this.repositoryId, headRevision);
    }

    @Override
    public void delete(Transaction transaction, Resource resource) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        LOGGER.trace("deleting resource {} during transaction {}", (Object)resource, (Object)transaction.getId());
        this.delete0(transaction, new QualifiedResource(this.base, resource));
    }

    private void delete0(Transaction transaction, QualifiedResource resource) {
        Optional<Info> info = this.info0(transaction, resource, transaction.getHeadRevision(), false, LOCKING);
        info.orElseThrow(() -> new SubversionException("Can't resolve: " + resource + '@' + Revision.HEAD));
        QualifiedResource deleteResource = this.config.getWorkingResource(transaction).append(resource);
        Optional<LockToken> lockToken = info.flatMap(Info::getLockToken);
        DeleteOperation operation = new DeleteOperation(this.repository, deleteResource, lockToken);
        operation.execute(this.client, this.context);
        transaction.register(resource.getResource(), Transaction.Status.DELETED);
    }

    protected Revision determineHeadRevision() {
        InfoOperation operation = new InfoOperation(this.repository, this.base, new QualifiedResource(this.base, Resource.ROOT), this.config.getPrefix(), REVISION);
        Optional info = (Optional)operation.execute(this.client, this.context);
        return ((Info)info.orElseThrow(() -> new SubversionException("can not determine HEAD revision"))).getRevision();
    }

    @Override
    public InputStream download(Resource resource, Revision revision) {
        return this.download(this.createView(), resource, revision);
    }

    @Override
    public final InputStream download(View view, Resource resource, Revision revision) {
        Validate.notNull((Object)view, (String)"view must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        this.validateRevision(view, revision);
        LOGGER.trace("downloading resource {}@{}", (Object)resource, (Object)revision);
        return this.download0(view, new QualifiedResource(this.base, resource), revision);
    }

    private InputStream download0(View view, QualifiedResource resource, Revision revision) {
        QualifiedResource resolved = this.resolve(view, resource, revision, false);
        DownloadOperation operation = new DownloadOperation(this.repository, resolved);
        Object is = operation.execute(this.client, this.context);
        return (InputStream)((Optional)is).orElseThrow(() -> new SubversionException("Can't resolve: " + resource + '@' + revision));
    }

    @Override
    public URI downloadURI(Resource resource, Revision revision) {
        return this.downloadURI(this.createView(), resource, revision);
    }

    @Override
    public final URI downloadURI(View view, Resource resource, Revision revision) {
        Validate.notNull((Object)view, (String)"view must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        this.validateRevision(view, revision);
        LOGGER.trace("creating download uri for resource {}@{}", (Object)resource, (Object)revision);
        return this.downloadURI0(view, new QualifiedResource(this.base, resource), revision);
    }

    private URI downloadURI0(View view, QualifiedResource resource, Revision revision) {
        if (!this.exists0(view, resource, revision)) {
            throw new SubversionException("Can't resolve: " + resource + '@' + revision);
        }
        QualifiedResource resolved = this.resolve(view, resource, revision, true);
        return URIUtils.appendResources(this.repository, resolved);
    }

    @Override
    public boolean exists(Resource resource, Revision revision) {
        return this.exists(this.createView(), resource, revision);
    }

    @Override
    public final boolean exists(View view, Resource resource, Revision revision) {
        Validate.notNull((Object)view, (String)"view must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        this.validateRevision(view, revision);
        LOGGER.trace("checking existence for resource {}@{}", (Object)resource, (Object)revision);
        return this.exists0(view, new QualifiedResource(this.base, resource), revision);
    }

    private boolean exists0(View view, QualifiedResource resource, Revision revision) {
        QualifiedResource resolved = this.resolve(view, resource, revision, false);
        ExistsOperation operation = new ExistsOperation(this.repository, resolved, this.config.getPrefix());
        return (Boolean)operation.execute(this.client, this.context);
    }

    @Override
    public final Resource getBasePath() {
        return this.base;
    }

    @Override
    public final URI getBaseUri() {
        return URIUtils.appendResources(this.repository, new Resource[0]);
    }

    protected Revision getConcreteRevision(View view, Revision revision) {
        if (Revision.HEAD.equals(revision)) {
            return view.getHeadRevision();
        }
        return revision;
    }

    protected Set<Info> getInfoSetWithLockTokens(Transaction transaction) {
        this.validateTransaction(transaction);
        Map<Resource, Transaction.Status> changeSet = transaction.getChangeSet();
        if (changeSet.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<Info> infoSet = new TreeSet<Info>(Info.RESOURCE_COMPARATOR);
        for (Map.Entry<Resource, Transaction.Status> entry : changeSet.entrySet()) {
            QualifiedResource resource;
            Optional<Info> info;
            Transaction.Status status = entry.getValue();
            if (Transaction.Status.EXISTS == status || Transaction.Status.ADDED == status || !(info = this.info0(transaction, resource = new QualifiedResource(this.base, entry.getKey()), transaction.getHeadRevision(), false, LOCKING)).isPresent() || !info.get().isLocked()) continue;
            infoSet.add(info.get());
        }
        return infoSet;
    }

    @Override
    public final UUID getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public Info info(Resource resource, Revision revision, ResourceProperty.Key ... keys) {
        return this.info(this.createView(), resource, revision, keys);
    }

    @Override
    public Info info(View view, Resource resource, Revision revision, ResourceProperty.Key ... keys) {
        Validate.notNull((Object)view, (String)"view must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])keys, (String)"keys must not contain null elements", (Object[])new Object[0]);
        this.validateRevision(view, revision);
        LOGGER.trace("retrieving info for resource {}@{}", (Object)resource, (Object)revision);
        Optional<Info> info = this.info0(view, new QualifiedResource(this.base, resource), revision, true, keys);
        return info.orElseThrow(() -> new SubversionException("Can't resolve: " + resource + '@' + revision));
    }

    private Optional<Info> info0(View view, QualifiedResource resource, Revision revision, boolean resolve, ResourceProperty.Key[] keys) {
        QualifiedResource resolved = this.resolve(view, resource, revision, resolve);
        InfoOperation operation = new InfoOperation(this.repository, this.base, resolved, this.config.getPrefix(), keys);
        return (Optional)operation.execute(this.client, this.context);
    }

    @Override
    public Set<Info> list(Resource resource, Revision revision, Depth depth, ResourceProperty.Key ... keys) {
        return this.list(this.createView(), resource, revision, depth, keys);
    }

    @Override
    public Set<Info> list(View view, Resource resource, Revision revision, Depth depth, ResourceProperty.Key ... keys) {
        Validate.notNull((Object)view, (String)"view must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)depth), (String)"depth must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])keys, (String)"keys must not contain null elements", (Object[])new Object[0]);
        this.validateRevision(view, revision);
        LOGGER.trace("listing info for resource {}@{} and depth {}", new Object[]{resource, revision, depth});
        return this.list0(view, new QualifiedResource(this.base, resource), revision, depth, keys);
    }

    private Set<Info> list0(View view, QualifiedResource resource, Revision revision, Depth depth, ResourceProperty.Key[] keys) {
        if (Depth.INFINITY == depth) {
            TreeSet<Info> result = new TreeSet<Info>(Info.RESOURCE_COMPARATOR);
            this.listRecursively0(view, resource, revision, result, keys);
            return result;
        }
        QualifiedResource resolved = this.resolve(view, resource, revision, true);
        ListOperation operation = new ListOperation(this.repository, this.base, resolved, this.config.getPrefix(), depth, keys);
        Optional infoSet = (Optional)operation.execute(this.client, this.context);
        return (Set)infoSet.orElseThrow(() -> new SubversionException("Can't resolve: " + resource + '@' + revision));
    }

    private void listRecursively0(View view, QualifiedResource resource, Revision revision, Set<Info> result, ResourceProperty.Key[] keys) {
        for (Info info : this.list0(view, resource, revision, Depth.IMMEDIATES, keys)) {
            if (!result.add(info) || !info.isDirectory() || resource.getResource().equals(info.getResource())) continue;
            this.listRecursively0(view, new QualifiedResource(this.base, info.getResource()), revision, result, keys);
        }
    }

    @Override
    public final void lock(Resource resource, boolean steal) {
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        LOGGER.trace("locking resource {} (steal: {})", (Object)resource, (Object)steal);
        LockOperation operation = new LockOperation(this.repository, new QualifiedResource(this.base, resource), steal);
        operation.execute(this.client, this.context);
    }

    @Override
    public List<Log> log(Resource resource, Revision startRevision, Revision endRevision, int limit, boolean stopOnCopy) {
        return this.log(this.createView(), resource, startRevision, endRevision, limit, stopOnCopy);
    }

    @Override
    public final List<Log> log(View view, Resource resource, Revision startRevision, Revision endRevision, int limit, boolean stopOnCopy) {
        Validate.notNull((Object)view, (String)"view must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)startRevision, (String)"startRevision must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)endRevision, (String)"endRevision must not be null", (Object[])new Object[0]);
        this.validateRevision(view, startRevision);
        this.validateRevision(view, endRevision);
        LOGGER.trace("retrieving log for resource {} from {} to {} (limit: {})", new Object[]{resource, startRevision, endRevision, limit});
        return this.log0(view, new QualifiedResource(this.base, resource), startRevision, endRevision, limit, stopOnCopy);
    }

    private List<Log> log0(View view, QualifiedResource resource, Revision startRevision, Revision endRevision, int limit, boolean stopOnCopy) {
        Revision concreteEndRevision;
        Revision concreteStartRevision = this.getConcreteRevision(view, startRevision);
        Revision resoledRevision = concreteStartRevision.compareTo(concreteEndRevision = this.getConcreteRevision(view, endRevision)) > 0 ? concreteStartRevision : concreteEndRevision;
        QualifiedResource resolved = this.resolve(view, resource, resoledRevision, false);
        LogOperation operation = new LogOperation(this.repository, resolved, concreteStartRevision, concreteEndRevision, limit, stopOnCopy);
        return (List)operation.execute(this.client, this.context);
    }

    @Override
    public void mkdir(Transaction transaction, Resource resource, boolean parent) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        LOGGER.trace("creating folder for resource {} during {} (parent: {})", new Object[]{resource, transaction.getId(), parent});
        this.createFolder(transaction, new QualifiedResource(this.base, resource), parent);
    }

    @Override
    public void move(Transaction transaction, Resource srcResource, Resource targetResource, boolean parents) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)srcResource, (String)"srcResource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)targetResource, (String)"targetResource must not be null", (Object[])new Object[0]);
        LOGGER.trace("moving {} to {} during {} (parents: {})", new Object[]{srcResource, targetResource, transaction.getId(), parents});
        QualifiedResource qualifiedSourceResource = new QualifiedResource(this.base, srcResource);
        this.copy0(transaction, qualifiedSourceResource, transaction.getHeadRevision(), new QualifiedResource(this.base, targetResource), parents, false);
        this.delete0(transaction, qualifiedSourceResource);
    }

    @Override
    public void propertiesDelete(Transaction transaction, Resource resource, ResourceProperty ... properties) {
        this.propertiesUpdate(transaction, new QualifiedResource(this.base, resource), PropertiesUpdateOperation.Type.DELETE, properties);
    }

    @Override
    public void propertiesSet(Transaction transaction, Resource resource, ResourceProperty ... properties) {
        this.propertiesUpdate(transaction, new QualifiedResource(this.base, resource), PropertiesUpdateOperation.Type.SET, properties);
    }

    protected void propertiesUpdate(Transaction transaction, QualifiedResource resource, PropertiesUpdateOperation.Type type, ResourceProperty ... properties) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])properties, (String)"properties must not contain null elements", (Object[])new Object[0]);
        LOGGER.trace("updating properties {} on {} during {}", new Object[]{properties, resource.getResource(), transaction.getId()});
        Optional<Info> info = this.info0(transaction, resource, transaction.getHeadRevision(), false, LOCKING);
        Optional<LockToken> lockToken = info.flatMap(Info::getLockToken);
        QualifiedResource r = this.config.getWorkingResource(transaction).append(resource);
        PropertiesUpdateOperation operation = new PropertiesUpdateOperation(this.repository, r, type, lockToken, properties);
        operation.execute(this.client, this.context);
        transaction.register(resource.getResource(), Transaction.Status.MODIFIED);
    }

    protected abstract void registerResource(Transaction var1, Resource var2, Revision var3);

    protected QualifiedResource resolve(View view, QualifiedResource resource, Revision revision, boolean resolve) {
        if (Revision.HEAD.equals(revision)) {
            if (resolve) {
                return this.config.getVersionedResource(resource, view.getHeadRevision());
            }
            return resource;
        }
        if (resolve) {
            ResolveOperation r = new ResolveOperation(this.repository, resource, view.getHeadRevision(), revision, this.config);
            return ((Optional)r.execute(this.client, this.context)).orElse(this.config.getVersionedResource(resource, revision));
        }
        return this.config.getVersionedResource(resource, revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Transaction transaction) {
        this.validateTransaction(transaction);
        LOGGER.trace("rolling transaction {} back", (Object)transaction.getId());
        try {
            QualifiedResource resource = this.config.getTransactionResource(transaction);
            Optional<LockToken> token = Optional.empty();
            DeleteOperation operation = new DeleteOperation(this.repository, resource, token);
            operation.execute(this.client, this.context);
        }
        finally {
            transaction.invalidate();
        }
    }

    @Override
    public void rollbackIfNotCommitted(Transaction transaction) {
        Validate.notNull((Object)transaction, (String)"transaction must not be null", (Object[])new Object[0]);
        if (transaction.isActive()) {
            this.rollback(transaction);
        }
    }

    @Override
    public final void unlock(Resource resource, boolean force) {
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        LOGGER.trace("unlocking {} (force: {})", (Object)resource, (Object)force);
        this.unlock0(this.createView(), new QualifiedResource(this.base, resource), force);
    }

    private void unlock0(View view, QualifiedResource resource, boolean force) {
        Optional<Info> info = this.info0(view, resource, view.getHeadRevision(), true, LOCKING);
        Optional<LockToken> lockToken = info.orElseThrow(() -> new SubversionException("Can't resolve: " + resource + '@' + view.getHeadRevision())).getLockToken();
        if (!lockToken.isPresent()) {
            return;
        }
        UnlockOperation operation = new UnlockOperation(this.repository, resource, lockToken.get(), force);
        operation.execute(this.client, this.context);
    }

    protected void validateRevision(View view, Revision revision) {
        if (Revision.HEAD.equals(revision)) {
            return;
        }
        Revision headRevision = view.getHeadRevision();
        if (headRevision.compareTo(revision) < 0) {
            throw new SubversionException("revision " + revision + " is to new for Transaction/View with head revision " + headRevision);
        }
    }

    protected void validateTransaction(Transaction transaction) {
        Validate.notNull((Object)transaction, (String)"transaction must not be null", (Object[])new Object[0]);
        this.validateView(transaction);
        if (!transaction.isActive()) {
            throw new SubversionException("Transaction invalid: has already been committed or reverted");
        }
    }

    protected void validateView(View view) {
        Validate.notNull((Object)view, (String)"view must not be null", (Object[])new Object[0]);
        UUID transactionRepositoryId = view.getRepositoryId();
        if (!this.repositoryId.equals(transactionRepositoryId)) {
            throw new SubversionException("Transaction/View invalid: does not belong to this repository");
        }
    }

    protected static interface ResourceMapper {
        public QualifiedResource getCommitMessageResource(Transaction var1);

        public QualifiedResource getCreateTransactionResource();

        public Resource getPrefix();

        public QualifiedResource getRegisterResource(QualifiedResource var1, Revision var2);

        public QualifiedResource getRegisterTransactionResource(Transaction var1);

        public QualifiedResource getTransactionResource(Transaction var1);

        public QualifiedResource getVersionedResource(QualifiedResource var1, Revision var2);

        public QualifiedResource getWorkingResource(Transaction var1);
    }
}

