/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion;

import java.util.Comparator;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.Validate;

@Immutable
public final class ResourceProperty {
    public static final Key AUTHOR = new Key(Type.DAV, "creator-displayname");
    public static final Key CREATION_DATE = new Key(Type.DAV, "creationdate");
    public static final Key LAST_MODIFIED_DATE = new Key(Type.DAV, "getlastmodified");
    public static final Key LOCK_STATUS = new Key(Type.DAV, "lockdiscovery");
    public static final Key MD5_HASH = new Key(Type.SUBVERSION_DAV, "md5-checksum");
    public static final Key REPOSITORY_ID = new Key(Type.SUBVERSION_DAV, "repository-uuid");
    public static final Key RESOURCE = new Key(Type.SUBVERSION_DAV, "baseline-relative-path");
    public static final Key RESOURCE_TYPE = new Key(Type.DAV, "resourcetype");
    public static final Comparator<ResourceProperty> TYPE_NAME_COMPARATOR = (rp1, rp2) -> {
        Validate.notNull((Object)rp1, (String)"rp1 must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)rp2, (String)"rp2 must not be null", (Object[])new Object[0]);
        return rp1.getKey().compareTo(rp2.getKey());
    };
    public static final Key VERSION = new Key(Type.DAV, "version-name");
    private final Key key;
    private final String value;

    public ResourceProperty(Type type, String name, String value) {
        Validate.notNull((Object)value, (String)"value must not be null", (Object[])new Object[0]);
        this.key = new Key(type, name);
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceProperty)) {
            return false;
        }
        ResourceProperty that = (ResourceProperty)o;
        if (!this.key.equals(that.key)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public Key getKey() {
        return this.key;
    }

    public String getName() {
        return this.key.getName();
    }

    public Type getType() {
        return this.key.getType();
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public String toString() {
        return "ResourceProperty{ key=" + this.key + ", value='" + this.value + "'}";
    }

    public static enum Type {
        DAV("DAV:"),
        SUBVERSION_CUSTOM("http://subversion.tigris.org/xmlns/custom/"),
        SUBVERSION_DAV("http://subversion.tigris.org/xmlns/dav/"),
        SUBVERSION_SVN("http://subversion.tigris.org/xmlns/svn/"),
        SVN("svn:");

        private final String prefix;

        private Type(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    public static final class Key
    implements Comparable<Key> {
        private final String name;
        private final Type type;

        public Key(Type type, String name) {
            Validate.notNull((Object)((Object)type), (String)"type must not be null", (Object[])new Object[0]);
            Validate.notNull((Object)name, (String)"name must not be null", (Object[])new Object[0]);
            this.type = type;
            this.name = name;
        }

        @Override
        public int compareTo(Key other) {
            int result = this.type.compareTo(other.type);
            if (result != 0) {
                return result;
            }
            return this.name.compareTo(other.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (!this.name.equals(key.name)) {
                return false;
            }
            return this.type == key.type;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public String toString() {
            return "Key{type=" + (Object)((Object)this.type) + ", name='" + this.name + "'}";
        }
    }
}

