/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.http.client;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.Immutable;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;

@Immutable
public class SubversionRequestRetryHandler
extends DefaultHttpRequestRetryHandler {
    public static final int DEFAULT_RETRIES = 3;
    private final Map<String, Boolean> idempotentMethods = new HashMap<String, Boolean>();

    public SubversionRequestRetryHandler() {
        this(3, true);
    }

    public SubversionRequestRetryHandler(int retryCount, boolean requestSentRetryEnabled) {
        super(retryCount, requestSentRetryEnabled);
        this.idempotentMethods.put("DELETE", Boolean.TRUE);
        this.idempotentMethods.put("GET", Boolean.TRUE);
        this.idempotentMethods.put("HEAD", Boolean.TRUE);
        this.idempotentMethods.put("OPTIONS", Boolean.TRUE);
        this.idempotentMethods.put("PUT", Boolean.TRUE);
        this.idempotentMethods.put("POST", Boolean.TRUE);
        this.idempotentMethods.put("TRACE", Boolean.TRUE);
        this.idempotentMethods.put("CHECKOUT", Boolean.TRUE);
        this.idempotentMethods.put("COPY", Boolean.TRUE);
        this.idempotentMethods.put("LOCK", Boolean.TRUE);
        this.idempotentMethods.put("MERGE", Boolean.TRUE);
        this.idempotentMethods.put("MKACTIVITY", Boolean.TRUE);
        this.idempotentMethods.put("MKCOL", Boolean.FALSE);
        this.idempotentMethods.put("PROPFIND", Boolean.TRUE);
        this.idempotentMethods.put("PROPPATCH", Boolean.TRUE);
        this.idempotentMethods.put("REPORT", Boolean.TRUE);
        this.idempotentMethods.put("UNLOCK", Boolean.TRUE);
    }

    protected boolean handleAsIdempotent(HttpRequest request) {
        String method = request.getRequestLine().getMethod().toUpperCase(Locale.US);
        Boolean b = this.idempotentMethods.get(method);
        return b != null && b != false;
    }
}

