/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal.httpv2;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.TransactionImpl;
import de.shadowhunt.subversion.internal.URIUtils;
import java.net.URI;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

class CreateTransactionOperation
extends AbstractOperation<TransactionImpl> {
    private static final HttpEntity ENTITY;
    private static final String TRANSACTION_ID_HEADER = "SVN-Txn-Name";
    private final Revision headRevision;
    private final UUID repositoryId;
    private final Resource resource;

    CreateTransactionOperation(URI repository, UUID repositoryId, Resource resource, Revision headRevision) {
        super(repository);
        this.repositoryId = repositoryId;
        this.resource = resource;
        this.headRevision = headRevision;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        HttpPost request = new HttpPost(uri);
        request.setEntity(ENTITY);
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 201 == statusCode;
    }

    @Override
    protected TransactionImpl processResponse(HttpResponse response) {
        String transactionId = response.getFirstHeader(TRANSACTION_ID_HEADER).getValue();
        return new TransactionImpl(transactionId, this.repositoryId, this.headRevision);
    }

    static {
        ContentType contentType = ContentType.create((String)"application/vnd.svn-skel");
        ENTITY = new StringEntity("( create-txn )", contentType);
    }
}

