/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal.httpv1;

import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Repository;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.Transaction;
import de.shadowhunt.subversion.internal.AbstractBaseRepository;
import de.shadowhunt.subversion.internal.CommitMessageOperation;
import de.shadowhunt.subversion.internal.MergeOperation;
import de.shadowhunt.subversion.internal.TransactionImpl;
import de.shadowhunt.subversion.internal.httpv1.CheckoutOperation;
import de.shadowhunt.subversion.internal.httpv1.CreateTransactionOperation;
import java.net.URI;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepositoryImpl
extends AbstractBaseRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"de.shadowhunt.subversion.Repository");

    RepositoryImpl(URI repository, Resource prefix, HttpClient client, HttpContext context) {
        super(repository, new ResourceMapperImpl(prefix), client, context);
    }

    @Override
    public void commit(Transaction transaction, @CheckForNull String message) {
        this.validateTransaction(transaction);
        LOGGER.trace("committing {} with message {}", (Object)transaction.getId(), (Object)message);
        if (transaction.isChangeSetEmpty()) {
            this.rollback(transaction);
            return;
        }
        Revision concreteRevision = transaction.getHeadRevision();
        Resource messageResource = this.config.getCommitMessageResource(transaction).append(Resource.create(concreteRevision.toString()));
        CommitMessageOperation cmo = new CommitMessageOperation(this.repository, messageResource, message);
        cmo.execute(this.client, this.context);
        Set<Info> lockTokenInfoSet = this.getInfoSetWithLockTokens(transaction);
        Resource mergeResource = this.config.getTransactionResource(transaction);
        MergeOperation mo = new MergeOperation(this.repository, mergeResource, lockTokenInfoSet);
        mo.execute(this.client, this.context);
        transaction.invalidate();
    }

    @Override
    public Transaction createTransaction() {
        LOGGER.trace("creating new transaction");
        Resource resource = this.config.getCreateTransactionResource();
        Revision headRevision = this.determineHeadRevision();
        CreateTransactionOperation cto = new CreateTransactionOperation(this.repository, this.repositoryId, resource, headRevision);
        TransactionImpl transaction = (TransactionImpl)cto.execute(this.client, this.context);
        resource = this.config.getRegisterTransactionResource(transaction);
        Resource transactionResource = this.config.getTransactionResource(transaction);
        CheckoutOperation co = new CheckoutOperation(this.repository, resource, transactionResource);
        co.execute(this.client, this.context);
        return transaction;
    }

    @Override
    public Repository.ProtocolVersion getProtocolVersion() {
        return Repository.ProtocolVersion.HTTP_V1;
    }

    @Override
    protected void registerResource(Transaction transaction, Resource resource, Revision revision) {
        this.validateTransaction(transaction);
        Revision concreteRevision = this.getConcreteRevision(transaction, revision);
        Resource existingResource = this.config.getRegisterResource(resource, concreteRevision);
        Resource transactionResource = this.config.getTransactionResource(transaction);
        CheckoutOperation co = new CheckoutOperation(this.repository, existingResource, transactionResource);
        co.execute(this.client, this.context);
        transaction.register(resource, Transaction.Status.EXISTS);
    }

    private static class ResourceMapperImpl
    implements AbstractBaseRepository.ResourceMapper {
        private static final Resource CREATE_TRANSACTION = Resource.create("act");
        private static final Resource REGISTER_TRANSACTION = Resource.create("/vcc/default");
        private final Resource prefix;

        public ResourceMapperImpl(Resource prefix) {
            this.prefix = prefix;
        }

        @Override
        public Resource getCommitMessageResource(Transaction transaction) {
            Resource suffix = Resource.create("/wbl/" + transaction.getId());
            return this.prefix.append(suffix);
        }

        @Override
        public Resource getCreateTransactionResource() {
            return this.prefix.append(CREATE_TRANSACTION);
        }

        @Override
        public Resource getPrefix() {
            return this.prefix;
        }

        @Override
        public Resource getRegisterResource(Resource resource, Revision revision) {
            if (Revision.HEAD.equals(revision)) {
                throw new SubversionException("must not be HEAD revision");
            }
            Resource suffix = Resource.create("/ver/" + revision + "/" + resource);
            return this.prefix.append(suffix);
        }

        @Override
        public Resource getRegisterTransactionResource(Transaction transaction) {
            return this.prefix.append(REGISTER_TRANSACTION);
        }

        @Override
        public Resource getTransactionResource(Transaction transaction) {
            Resource suffix = Resource.create("/act/" + transaction.getId());
            return this.prefix.append(suffix);
        }

        @Override
        public Resource getVersionedResource(Resource resource, Revision revision) {
            if (Revision.HEAD.equals(revision)) {
                throw new SubversionException("must not be HEAD revision");
            }
            Resource suffix = Resource.create("/bc/" + revision + "/" + resource);
            return this.prefix.append(suffix);
        }

        @Override
        public Resource getWorkingResource(Transaction transaction) {
            Resource suffix = Resource.create("/wrk/" + transaction.getId());
            return this.prefix.append(suffix);
        }
    }
}

