/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.CheckForNull;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;

class UploadOperation
extends AbstractVoidOperation {
    private static final long STREAM_WHOLE_CONTENT = -1L;
    private final InputStream content;
    private final String lockToken;
    private final Resource resource;

    UploadOperation(URI repository, Resource resource, @CheckForNull String lockToken, InputStream content) {
        super(repository);
        this.resource = resource;
        this.lockToken = lockToken;
        this.content = content;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        HttpPut request = new HttpPut(uri);
        if (this.lockToken != null) {
            request.addHeader("If", "<" + uri + "> (<" + this.lockToken + ">)");
        }
        request.setEntity((HttpEntity)new InputStreamEntity(this.content, -1L));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 201 == statusCode || 204 == statusCode;
    }
}

