/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;

public final class URIUtils {
    public static URI createURI(URI repository, Resource ... resources) {
        try {
            return URIUtils.createURI0(repository, resources);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static URI createURI0(URI repository, Resource ... resources) throws URISyntaxException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(repository.getScheme());
        builder.setHost(repository.getHost());
        builder.setPort(repository.getPort());
        StringBuilder completePath = new StringBuilder(repository.getPath());
        for (Resource resource : resources) {
            completePath.append(resource.getValue());
        }
        builder.setPath(completePath.toString());
        return builder.build();
    }

    private URIUtils() {
    }
}

