/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Depth;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

abstract class PropfindOperation<T>
extends AbstractOperation<T> {
    protected final Depth depth;
    protected final Resource marker;
    protected final ResourceProperty.Key[] requestedProperties;
    protected final Resource resource;

    @CheckForNull
    private static ResourceProperty.Key[] filter(ResourceProperty.Key[] requestedProperties) {
        if (requestedProperties == null) {
            return null;
        }
        int w = 0;
        int r = 0;
        while (r < requestedProperties.length) {
            if (ResourceProperty.Type.SUBVERSION_CUSTOM.equals((Object)requestedProperties[r].getType())) {
                ++r;
                continue;
            }
            requestedProperties[w++] = requestedProperties[r++];
        }
        return Arrays.copyOf(requestedProperties, w);
    }

    PropfindOperation(URI repository, Resource resource, Resource marker, Depth depth, @CheckForNull ResourceProperty.Key[] requestedProperties) {
        super(repository);
        this.resource = resource;
        this.marker = marker;
        this.depth = depth;
        this.requestedProperties = PropfindOperation.filter(requestedProperties);
    }

    private boolean contains(String namespace) {
        for (ResourceProperty.Key requestedProperty : this.requestedProperties) {
            if (!namespace.equals(requestedProperty.getType().getPrefix())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("PROPFIND", uri);
        request.addHeader("Depth", this.depth.value);
        StringBuilderWriter body = new StringBuilderWriter();
        try {
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter((Writer)body);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("propfind");
            writer.writeDefaultNamespace("DAV:");
            if (this.requestedProperties == null) {
                writer.writeEmptyElement("prop");
            } else if (this.requestedProperties.length == 0) {
                writer.writeEmptyElement("allprop");
            } else {
                writer.writeStartElement("prop");
                if (this.contains("http://subversion.tigris.org/xmlns/dav/")) {
                    writer.writeNamespace("V", "http://subversion.tigris.org/xmlns/dav/");
                    writer.setPrefix("V", "http://subversion.tigris.org/xmlns/dav/");
                }
                if (this.contains("http://subversion.tigris.org/xmlns/svn/")) {
                    writer.writeNamespace("S", "http://subversion.tigris.org/xmlns/svn/");
                    writer.setPrefix("S", "http://subversion.tigris.org/xmlns/svn/");
                }
                for (ResourceProperty.Key requestedProperty : this.requestedProperties) {
                    writer.writeEmptyElement(requestedProperty.getType().getPrefix(), requestedProperty.getName());
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new SubversionException("could not create request body", e);
        }
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 207 == statusCode || 404 == statusCode;
    }
}

