/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class PropertiesUpdateOperation
extends AbstractVoidOperation {
    private final String lockToken;
    private final ResourceProperty[] properties;
    private final Resource resource;
    private final Type type;

    PropertiesUpdateOperation(URI repository, Resource resource, Type type, @CheckForNull String lockToken, ResourceProperty[] properties) {
        super(repository);
        this.resource = resource;
        this.type = type;
        this.lockToken = lockToken;
        this.properties = Arrays.copyOf(properties, properties.length);
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("PROPPATCH", uri);
        if (this.lockToken != null) {
            request.addHeader("If", "<" + uri + "> (<" + this.lockToken + ">)");
        }
        StringBuilderWriter body = new StringBuilderWriter();
        try {
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter((Writer)body);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("propertyupdate");
            writer.writeDefaultNamespace("DAV:");
            writer.setPrefix("C", "http://subversion.tigris.org/xmlns/custom/");
            writer.writeNamespace("C", "http://subversion.tigris.org/xmlns/custom/");
            writer.setPrefix("V", "http://subversion.tigris.org/xmlns/dav/");
            writer.writeNamespace("V", "http://subversion.tigris.org/xmlns/dav/");
            writer.setPrefix("S", "http://subversion.tigris.org/xmlns/svn/");
            writer.writeNamespace("S", "http://subversion.tigris.org/xmlns/svn/");
            writer.writeStartElement(this.type.action);
            writer.writeStartElement("prop");
            for (ResourceProperty property : this.properties) {
                String prefix = property.getType().getPrefix();
                if (this.type == Type.SET) {
                    writer.writeStartElement(prefix, property.getName());
                    writer.writeCharacters(property.getValue());
                    writer.writeEndElement();
                    continue;
                }
                writer.writeEmptyElement(prefix, property.getName());
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new SubversionException("could not create request body", e);
        }
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 207 == statusCode;
    }

    static enum Type {
        SET("set"),
        DELETE("remove");

        final String action;

        private Type(String action) {
            this.action = action;
        }
    }
}

