/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Log;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.DateUtils;
import de.shadowhunt.subversion.internal.LogImpl;
import de.shadowhunt.subversion.xml.AbstractSaxExpression;
import de.shadowhunt.subversion.xml.AbstractSaxExpressionHandler;
import de.shadowhunt.subversion.xml.SaxExpression;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

final class LogImplReader {
    static List<Log> read(InputStream inputStream) throws IOException {
        LogHandler handler = new LogHandler();
        try {
            return (List)handler.parse(inputStream);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new SubversionException("Invalid server response: could not parse response", e);
        }
    }

    private LogImplReader() {
    }

    private static class RevisionExpression
    extends AbstractSaxExpression<Revision> {
        public static final QName[] PATH = new QName[]{new QName("DAV:", "version-name")};
        private Revision revision = null;

        RevisionExpression() {
            super(PATH);
        }

        @Override
        public Revision getValue() {
            return this.revision;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            int version = Integer.parseInt(text);
            this.revision = Revision.create(version);
        }

        @Override
        public void resetHandler() {
            this.revision = null;
        }
    }

    private static class LogHandler
    extends AbstractSaxExpressionHandler<List<Log>> {
        LogHandler() {
            super(new LogExpression());
        }

        @Override
        public List<Log> getValue() {
            LogExpression expression = (LogExpression)this.expressions[0];
            Object logs = expression.getValue();
            expression.clear();
            return logs;
        }
    }

    private static class LogExpression
    extends AbstractSaxExpression<List<Log>> {
        private static final QName[] PATH = new QName[]{new QName("svn:", "log-report"), new QName("svn:", "log-item")};
        private List<Log> entries = new ArrayList<Log>();

        private static SaxExpression[] createExpressions() {
            return new SaxExpression[]{new CommentExpression(), new CreatorExpression(), new DateExpression(), new RevisionExpression()};
        }

        LogExpression() {
            super(PATH, LogExpression.createExpressions());
        }

        @Override
        public void clear() {
            this.entries = new ArrayList<Log>();
        }

        @Override
        public List<Log> getValue() {
            return this.entries;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            LogImpl log = new LogImpl();
            log.setMessage(((CommentExpression)this.children[0]).getValue());
            log.setAuthor(((CreatorExpression)this.children[1]).getValue());
            log.setDate(((DateExpression)this.children[2]).getValue());
            log.setRevision(((RevisionExpression)this.children[3]).getValue());
            this.entries.add(log);
        }
    }

    private static class DateExpression
    extends AbstractSaxExpression<Date> {
        public static final QName[] PATH = new QName[]{new QName("svn:", "date")};
        private Date date = null;

        DateExpression() {
            super(PATH);
        }

        @Override
        public Date getValue() {
            return this.date;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            this.date = DateUtils.parseCreatedDate(text);
        }

        @Override
        public void resetHandler() {
            this.date = null;
        }
    }

    private static class CreatorExpression
    extends AbstractSaxExpression<String> {
        private static final QName[] PATH = new QName[]{new QName("DAV:", "creator-displayname")};
        private String creator = "";

        CreatorExpression() {
            super(PATH);
        }

        @Override
        public String getValue() {
            return this.creator;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            this.creator = text;
        }

        @Override
        public void resetHandler() {
            this.creator = "";
        }
    }

    private static class CommentExpression
    extends AbstractSaxExpression<String> {
        private static final QName[] PATH = new QName[]{new QName("DAV:", "comment")};
        private String comment = "";

        CommentExpression() {
            super(PATH);
        }

        @Override
        public String getValue() {
            return this.comment;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            this.comment = text;
        }

        @Override
        public void resetHandler() {
            this.comment = "";
        }
    }
}

