/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Depth;
import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.internal.InfoImplReader;
import de.shadowhunt.subversion.internal.PropfindOperation;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;

class ListOperation
extends PropfindOperation<Set<Info>> {
    ListOperation(URI repository, Resource resource, Resource marker, Depth depth, ResourceProperty.Key[] requestedProperties) {
        super(repository, resource, marker, depth, requestedProperties);
    }

    @Override
    @CheckForNull
    public Set<Info> execute(HttpClient client, HttpContext context) {
        return (Set)super.execute(client, context);
    }

    @Override
    @CheckForNull
    protected Set<Info> processResponse(HttpResponse response) throws IOException {
        if (ListOperation.getStatusCode(response) == 404) {
            return null;
        }
        TreeSet<Info> result = new TreeSet<Info>(Info.RESOURCE_COMPARATOR);
        List<Info> infoList = InfoImplReader.readAll(ListOperation.getContent(response));
        result.addAll(infoList);
        return result;
    }
}

