/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Depth;
import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.internal.InfoImpl;
import de.shadowhunt.subversion.internal.InfoImplReader;
import de.shadowhunt.subversion.internal.PropfindOperation;
import java.io.IOException;
import java.net.URI;
import javax.annotation.CheckForNull;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;

class InfoOperation
extends PropfindOperation<Info> {
    private static final String LOCK_OWNER_HEADER = "X-SVN-Lock-Owner";

    InfoOperation(URI repository, Resource resource, Resource marker, @CheckForNull ResourceProperty.Key[] requestedProperties) {
        super(repository, resource, marker, Depth.EMPTY, requestedProperties);
    }

    @Override
    @CheckForNull
    public Info execute(HttpClient client, HttpContext context) {
        return (Info)super.execute(client, context);
    }

    @Override
    @CheckForNull
    protected Info processResponse(HttpResponse response) throws IOException {
        if (InfoOperation.getStatusCode(response) == 404) {
            return null;
        }
        Info info = InfoImplReader.read(InfoOperation.getContent(response));
        if (info.isLocked()) {
            Header header = response.getFirstHeader(LOCK_OWNER_HEADER);
            ((InfoImpl)info).setLockOwner(header.getValue());
        }
        return info;
    }
}

