/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.TransmissionException;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.CheckForNull;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

class DownloadOperation
extends AbstractOperation<InputStream> {
    private final Resource resource;

    DownloadOperation(URI repository, Resource resource) {
        super(repository);
        this.resource = resource;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        return new HttpGet(uri);
    }

    @Override
    @CheckForNull
    public InputStream execute(HttpClient client, HttpContext context) {
        HttpUriRequest request = this.createRequest();
        try {
            HttpResponse response = client.execute(request, context);
            if (DownloadOperation.getStatusCode(response) == 404) {
                return null;
            }
            InputStream content = DownloadOperation.getContent(response);
            this.check(response);
            return content;
        }
        catch (IOException e) {
            throw new TransmissionException(e);
        }
    }

    @Override
    public InputStream handleResponse(HttpResponse response) {
        return this.processResponse(response);
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 200 == statusCode || 404 == statusCode;
    }

    @Override
    protected InputStream processResponse(HttpResponse response) {
        throw new UnsupportedOperationException();
    }
}

