/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.net.URI;
import javax.annotation.CheckForNull;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;

class DeleteOperation
extends AbstractVoidOperation {
    private final String lockToken;
    private final Resource resource;

    public DeleteOperation(URI repository, Resource resource, @CheckForNull String lockToken) {
        super(repository);
        this.resource = resource;
        this.lockToken = lockToken;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        HttpDelete request = new HttpDelete(uri);
        if (this.lockToken != null) {
            request.addHeader("If", "<" + uri + "> (<" + this.lockToken + ">)");
        }
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 204 == statusCode;
    }
}

