/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.TransmissionException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.stream.XMLOutputFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HttpContext;

public abstract class AbstractOperation<T>
implements ResponseHandler<T> {
    protected static final ContentType CONTENT_TYPE_XML = ContentType.create((String)"text/xml", (String)"UTF-8");
    protected static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    protected final URI repository;

    static InputStream getContent(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new IOException("Invalid server response: entity is missing");
        }
        return entity.getContent();
    }

    static int getStatusCode(HttpResponse response) {
        StatusLine statusLine = response.getStatusLine();
        return statusLine == null ? 0 : statusLine.getStatusCode();
    }

    protected AbstractOperation(URI repository) {
        this.repository = repository;
    }

    protected void check(HttpResponse response) {
        String message;
        int statusCode = AbstractOperation.getStatusCode(response);
        if (this.isExpectedStatusCode(statusCode)) {
            return;
        }
        switch (statusCode) {
            case 401: {
                message = "Missing or insufficient user credentials to execute operation";
                break;
            }
            case 403: {
                message = "Operation can not be executed";
                break;
            }
            case 404: {
                message = "Requested resource could not be found";
                break;
            }
            case 423: {
                message = "Requested resource is locked by another user";
                break;
            }
            default: {
                message = "Unexpected server response";
            }
        }
        throw new SubversionException(message, statusCode);
    }

    final void clearRedirects(HttpContext context) {
        context.removeAttribute("http.protocol.redirect-locations");
    }

    protected abstract HttpUriRequest createRequest();

    public T execute(HttpClient client, HttpContext context) {
        HttpUriRequest request = this.createRequest();
        this.clearRedirects(context);
        try {
            return (T)client.execute(request, (ResponseHandler)this, context);
        }
        catch (IOException e) {
            throw new TransmissionException(e);
        }
    }

    public T handleResponse(HttpResponse response) throws IOException {
        this.check(response);
        return this.processResponse(response);
    }

    protected abstract boolean isExpectedStatusCode(int var1);

    protected abstract T processResponse(HttpResponse var1) throws IOException;

    protected static final class DavTemplateRequest
    extends HttpEntityEnclosingRequestBase {
        private final String method;

        public DavTemplateRequest(String method, URI uri) {
            this.method = method;
            this.setURI(uri);
        }

        public String getMethod() {
            return this.method;
        }
    }
}

