/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Depth;
import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Log;
import de.shadowhunt.subversion.Repository;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.Transaction;
import de.shadowhunt.subversion.View;
import de.shadowhunt.subversion.internal.CopyOperation;
import de.shadowhunt.subversion.internal.CreateFolderOperation;
import de.shadowhunt.subversion.internal.DeleteOperation;
import de.shadowhunt.subversion.internal.DownloadOperation;
import de.shadowhunt.subversion.internal.ExistsOperation;
import de.shadowhunt.subversion.internal.InfoOperation;
import de.shadowhunt.subversion.internal.ListOperation;
import de.shadowhunt.subversion.internal.LockOperation;
import de.shadowhunt.subversion.internal.LogOperation;
import de.shadowhunt.subversion.internal.PropertiesUpdateOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import de.shadowhunt.subversion.internal.UnlockOperation;
import de.shadowhunt.subversion.internal.UploadOperation;
import de.shadowhunt.subversion.internal.ViewImpl;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.CheckForNull;
import org.apache.commons.lang3.Validate;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseRepository
implements Repository {
    private static final ResourceProperty.Key[] LOCKING = new ResourceProperty.Key[]{ResourceProperty.RESOURCE, ResourceProperty.LOCK_STATUS};
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"de.shadowhunt.subversion.Repository");
    private static final ResourceProperty.Key[] REPOSITORY_UUID = new ResourceProperty.Key[]{ResourceProperty.REPOSITORY_ID};
    private static final ResourceProperty.Key[] REVISION = new ResourceProperty.Key[]{ResourceProperty.RESOURCE, ResourceProperty.VERSION};
    private static final ResourceProperty.Key[] TYPE = new ResourceProperty.Key[]{ResourceProperty.RESOURCE, ResourceProperty.RESOURCE_TYPE};
    protected final HttpClient client;
    protected final ResourceMapper config;
    protected final HttpContext context;
    protected final URI repository;
    protected final UUID repositoryId;

    @CheckForNull
    private static UUID determineRepositoryId(URI repository, HttpClient client, HttpContext context, Resource marker) {
        InfoOperation operation = new InfoOperation(repository, Resource.ROOT, marker, REPOSITORY_UUID);
        Info info = operation.execute(client, context);
        if (info == null) {
            throw new SubversionException("No repository found at " + repository, 400);
        }
        return info.getRepositoryId();
    }

    protected AbstractBaseRepository(URI repository, ResourceMapper config, HttpClient client, HttpContext context) {
        Validate.notNull((Object)repository, (String)"repository must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)config, (String)"config must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)client, (String)"client must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)context, (String)"context must not be null", (Object[])new Object[0]);
        this.repository = URIUtils.createURI(repository, new Resource[0]);
        this.config = config;
        this.client = client;
        this.context = context;
        this.repositoryId = AbstractBaseRepository.determineRepositoryId(repository, client, context, config.getPrefix());
        Validate.notNull((Object)this.repositoryId, (String)"repositoryId must not be null", (Object[])new Object[0]);
    }

    @Override
    public void add(Transaction transaction, Resource resource, boolean parents, InputStream content) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)content, (String)"content must not be null", (Object[])new Object[0]);
        LOGGER.trace("adding resource {} during transaction {} (parents: {})", new Object[]{resource, transaction.getId(), parents});
        if (parents) {
            this.mkdir(transaction, resource.getParent(), true);
        }
        Info info = this.info0(transaction, resource, transaction.getHeadRevision(), true, LOCKING);
        String lockToken = null;
        if (info != null) {
            lockToken = info.getLockToken();
        }
        Resource uploadResource = this.config.getWorkingResource(transaction).append(resource);
        UploadOperation operation = new UploadOperation(this.repository, uploadResource, lockToken, content);
        operation.execute(this.client, this.context);
        if (info == null) {
            transaction.register(resource, Transaction.Status.ADDED);
        } else {
            transaction.register(resource, Transaction.Status.MODIFIED);
        }
    }

    @Override
    public void copy(Transaction transaction, Resource sourceResource, Revision sourceRevision, Resource targetResource, boolean parents) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)sourceResource, (String)"sourceResource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)sourceRevision, (String)"sourceRevision must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)targetResource, (String)"targetResource must not be null", (Object[])new Object[0]);
        this.validateRevision(transaction, sourceRevision);
        LOGGER.trace("copying resource from {}@{} to {} during transaction {} (parents: {})", new Object[]{sourceResource, sourceRevision, targetResource, transaction.getId(), parents});
        if (parents) {
            this.createFolder(transaction, targetResource.getParent(), true);
        } else {
            this.registerResource(transaction, targetResource.getParent(), transaction.getHeadRevision());
        }
        Info sourceInfo = this.info0(transaction, sourceResource, sourceRevision, true, REVISION);
        if (sourceInfo == null) {
            throw new SubversionException("Can't resolve: " + sourceResource + '@' + sourceRevision);
        }
        Info targetInfo = this.info0(transaction, targetResource, transaction.getHeadRevision(), true, LOCKING);
        String lockToken = null;
        if (targetInfo != null) {
            lockToken = targetInfo.getLockToken();
        }
        Resource source = this.config.getVersionedResource(sourceInfo.getResource(), sourceInfo.getRevision());
        Resource target = this.config.getWorkingResource(transaction).append(targetResource);
        CopyOperation operation = new CopyOperation(this.repository, source, target, lockToken);
        operation.execute(this.client, this.context);
        if (targetInfo == null) {
            transaction.register(targetResource, Transaction.Status.ADDED);
        } else {
            transaction.register(targetResource, Transaction.Status.MODIFIED);
        }
    }

    private void createFolder(Transaction transaction, Resource resource, boolean parents) {
        Info info = this.info0(transaction, resource, transaction.getHeadRevision(), true, TYPE);
        if (parents && info == null && !Resource.ROOT.equals(resource)) {
            this.createFolder(transaction, resource.getParent(), true);
        }
        if (info == null) {
            Resource folder = this.config.getWorkingResource(transaction).append(resource);
            CreateFolderOperation operation = new CreateFolderOperation(this.repository, folder);
            operation.execute(this.client, this.context);
            transaction.register(resource, Transaction.Status.ADDED);
        } else {
            if (info.isFile()) {
                throw new SubversionException("Can not create folder. File with same name already exists: " + resource);
            }
            Transaction.Status status = transaction.getChangeSet().get(resource);
            if (status == null) {
                this.registerResource(transaction, resource, transaction.getHeadRevision());
            }
        }
        Resource current = resource.getParent();
        while (!Resource.ROOT.equals(current) && transaction.register(current, Transaction.Status.EXISTS)) {
            current = current.getParent();
        }
    }

    @Override
    public View createView() {
        LOGGER.trace("creating new view");
        Revision headRevision = this.determineHeadRevision();
        return new ViewImpl(this.repositoryId, headRevision);
    }

    @Override
    public void delete(Transaction transaction, Resource resource) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        LOGGER.trace("deleting resource {} during transaction {}", (Object)resource, (Object)transaction.getId());
        Info info = this.info0(transaction, resource, transaction.getHeadRevision(), true, LOCKING);
        if (info == null) {
            throw new SubversionException("Can't resolve: " + resource + '@' + Revision.HEAD);
        }
        DeleteOperation operation = new DeleteOperation(this.repository, this.config.getWorkingResource(transaction).append(resource), info.getLockToken());
        operation.execute(this.client, this.context);
        transaction.register(resource, Transaction.Status.DELETED);
    }

    protected Revision determineHeadRevision() {
        InfoOperation operation = new InfoOperation(this.repository, Resource.ROOT, this.config.getPrefix(), REVISION);
        Info info = operation.execute(this.client, this.context);
        if (info == null) {
            throw new SubversionException("can not determine HEAD revision");
        }
        return info.getRevision();
    }

    @Override
    public final InputStream download(View view, Resource resource, Revision revision) {
        Validate.notNull((Object)view, (String)"view must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        this.validateRevision(view, revision);
        LOGGER.trace("downloading resource {}@{}", (Object)resource, (Object)revision);
        return this.download0(view, resource, revision);
    }

    @Override
    public InputStream download(Resource resource, Revision revision) {
        return this.download(this.createView(), resource, revision);
    }

    private InputStream download0(View view, Resource resource, Revision revision) {
        Resource resolved = this.resolve2(view, resource, revision, false);
        DownloadOperation operation = new DownloadOperation(this.repository, resolved);
        InputStream is = operation.execute(this.client, this.context);
        if (is == null) {
            throw new SubversionException("Can't resolve: " + resource + '@' + revision);
        }
        return is;
    }

    @Override
    public final URI downloadURI(View view, Resource resource, Revision revision) {
        Validate.notNull((Object)view, (String)"view must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        this.validateRevision(view, revision);
        LOGGER.trace("creating download uri for resource {}@{}", (Object)resource, (Object)revision);
        return this.downloadURI0(view, resource, revision);
    }

    @Override
    public URI downloadURI(Resource resource, Revision revision) {
        return this.downloadURI(this.createView(), resource, revision);
    }

    private URI downloadURI0(View view, Resource resource, Revision revision) {
        if (!this.exists0(view, resource, revision)) {
            throw new SubversionException("Can't resolve: " + resource + '@' + revision);
        }
        Resource resolved = this.resolve2(view, resource, revision, true);
        return URIUtils.createURI(this.repository, resolved);
    }

    @Override
    public final boolean exists(View view, Resource resource, Revision revision) {
        Validate.notNull((Object)view, (String)"view must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        this.validateRevision(view, revision);
        LOGGER.trace("checking existence for resource {}@{}", (Object)resource, (Object)revision);
        return this.exists0(view, resource, revision);
    }

    @Override
    public boolean exists(Resource resource, Revision revision) {
        return this.exists(this.createView(), resource, revision);
    }

    private boolean exists0(View view, Resource resource, Revision revision) {
        Resource resolved = this.resolve2(view, resource, revision, false);
        ExistsOperation operation = new ExistsOperation(this.repository, resolved, this.config.getPrefix());
        return (Boolean)operation.execute(this.client, this.context);
    }

    @Override
    public final URI getBaseUri() {
        return URIUtils.createURI(this.repository, new Resource[0]);
    }

    protected Revision getConcreteRevision(View view, Revision revision) {
        if (Revision.HEAD.equals(revision)) {
            return view.getHeadRevision();
        }
        return revision;
    }

    protected Set<Info> getInfoSetWithLockTokens(Transaction transaction) {
        this.validateTransaction(transaction);
        Map<Resource, Transaction.Status> changeSet = transaction.getChangeSet();
        if (changeSet.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<Info> infoSet = new TreeSet<Info>(Info.RESOURCE_COMPARATOR);
        for (Map.Entry<Resource, Transaction.Status> entry : changeSet.entrySet()) {
            Resource resource;
            Info info;
            Transaction.Status status = entry.getValue();
            if (Transaction.Status.EXISTS == status || Transaction.Status.ADDED == status || (info = this.info0(transaction, resource = entry.getKey(), transaction.getHeadRevision(), false, LOCKING)) == null || !info.isLocked()) continue;
            infoSet.add(info);
        }
        return infoSet;
    }

    @Override
    public final UUID getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public Info info(Resource resource, Revision revision, ResourceProperty.Key ... keys) {
        return this.info(this.createView(), resource, revision, keys);
    }

    @Override
    public Info info(View view, Resource resource, Revision revision, ResourceProperty.Key ... keys) {
        Validate.notNull((Object)view, (String)"view must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])keys, (String)"keys must not contain null elements", (Object[])new Object[0]);
        this.validateRevision(view, revision);
        LOGGER.trace("retrieving info for resource {}@{}", (Object)resource, (Object)revision);
        Info info = this.info0(view, resource, revision, true, keys);
        if (info == null) {
            throw new SubversionException("Can't resolve: " + resource + '@' + revision);
        }
        return info;
    }

    @CheckForNull
    private Info info0(View view, Resource resource, Revision revision, boolean resolve, @CheckForNull ResourceProperty.Key[] keys) {
        Resource resolved = this.resolve2(view, resource, revision, resolve);
        InfoOperation operation = new InfoOperation(this.repository, resolved, this.config.getPrefix(), keys);
        return operation.execute(this.client, this.context);
    }

    @Override
    public Set<Info> list(Resource resource, Revision revision, Depth depth, ResourceProperty.Key ... keys) {
        return this.list(this.createView(), resource, revision, depth, keys);
    }

    @Override
    public Set<Info> list(View view, Resource resource, Revision revision, Depth depth, ResourceProperty.Key ... keys) {
        Validate.notNull((Object)view, (String)"view must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)revision, (String)"revision must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)depth), (String)"depth must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])keys, (String)"keys must not contain null elements", (Object[])new Object[0]);
        this.validateRevision(view, revision);
        LOGGER.trace("listing info for resource {}@{} and depth {}", new Object[]{resource, revision, depth});
        return this.list0(view, resource, revision, depth, keys);
    }

    private Set<Info> list0(View view, Resource resource, Revision revision, Depth depth, @CheckForNull ResourceProperty.Key[] keys) {
        if (Depth.INFINITY == depth) {
            TreeSet<Info> result = new TreeSet<Info>(Info.RESOURCE_COMPARATOR);
            this.listRecursively0(view, resource, revision, result, keys);
            return result;
        }
        Resource resolved = this.resolve2(view, resource, revision, true);
        ListOperation operation = new ListOperation(this.repository, resolved, this.config.getPrefix(), depth, keys);
        Object infoSet = operation.execute(this.client, this.context);
        if (infoSet == null) {
            throw new SubversionException("Can't resolve: " + resource + '@' + revision);
        }
        return infoSet;
    }

    private void listRecursively0(View view, Resource resource, Revision revision, Set<Info> result, @CheckForNull ResourceProperty.Key[] keys) {
        for (Info info : this.list0(view, resource, revision, Depth.IMMEDIATES, keys)) {
            if (!result.add(info) || !info.isDirectory() || resource.equals(info.getResource())) continue;
            this.listRecursively0(view, info.getResource(), revision, result, keys);
        }
    }

    @Override
    public final void lock(Resource resource, boolean steal) {
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        LOGGER.trace("locking resource {} (steal: {})", (Object)resource, (Object)steal);
        LockOperation operation = new LockOperation(this.repository, resource, steal);
        operation.execute(this.client, this.context);
    }

    @Override
    public final List<Log> log(View view, Resource resource, Revision startRevision, Revision endRevision, int limit) {
        Validate.notNull((Object)view, (String)"view must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)startRevision, (String)"startRevision must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)endRevision, (String)"endRevision must not be null", (Object[])new Object[0]);
        this.validateRevision(view, startRevision);
        this.validateRevision(view, endRevision);
        LOGGER.trace("retrieving log for resource {} from {} to {} (limit: {})", new Object[]{resource, startRevision, endRevision, limit});
        return this.log0(view, resource, startRevision, endRevision, limit);
    }

    @Override
    public List<Log> log(Resource resource, Revision startRevision, Revision endRevision, int limit) {
        return this.log(this.createView(), resource, startRevision, endRevision, limit);
    }

    private List<Log> log0(View view, Resource resource, Revision startRevision, Revision endRevision, int limit) {
        Revision concreteEndRevision;
        Revision concreteStartRevision = this.getConcreteRevision(view, startRevision);
        Revision resoledRevision = concreteStartRevision.compareTo(concreteEndRevision = this.getConcreteRevision(view, endRevision)) > 0 ? concreteStartRevision : concreteEndRevision;
        Resource resolved = this.resolve2(view, resource, resoledRevision, true);
        LogOperation operation = new LogOperation(this.repository, resolved, concreteStartRevision, concreteEndRevision, limit);
        return (List)operation.execute(this.client, this.context);
    }

    @Override
    public void mkdir(Transaction transaction, Resource resource, boolean parent) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        LOGGER.trace("creating folder for resource {} during {} (parent: {})", new Object[]{resource, transaction.getId(), parent});
        this.createFolder(transaction, resource, parent);
    }

    @Override
    public void move(Transaction transaction, Resource srcResource, Resource targetResource, boolean parents) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)srcResource, (String)"srcResource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)targetResource, (String)"targetResource must not be null", (Object[])new Object[0]);
        LOGGER.trace("moving {} to {} during {} (parents: {})", new Object[]{srcResource, targetResource, transaction.getId(), parents});
        this.copy(transaction, srcResource, transaction.getHeadRevision(), targetResource, parents);
        this.delete(transaction, srcResource);
    }

    @Override
    public void propertiesDelete(Transaction transaction, Resource resource, ResourceProperty ... properties) {
        this.propertiesUpdate(transaction, resource, PropertiesUpdateOperation.Type.DELETE, properties);
    }

    @Override
    public void propertiesSet(Transaction transaction, Resource resource, ResourceProperty ... properties) {
        this.propertiesUpdate(transaction, resource, PropertiesUpdateOperation.Type.SET, properties);
    }

    protected void propertiesUpdate(Transaction transaction, Resource resource, PropertiesUpdateOperation.Type type, ResourceProperty ... properties) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])properties, (String)"properties must not contain null elements", (Object[])new Object[0]);
        LOGGER.trace("updating properties {} on {} during {}", new Object[]{properties, resource, transaction.getId()});
        Info info = this.info0(transaction, resource, transaction.getHeadRevision(), true, LOCKING);
        String lockToken = null;
        if (info != null) {
            lockToken = info.getLockToken();
        }
        Resource r = this.config.getWorkingResource(transaction).append(resource);
        PropertiesUpdateOperation operation = new PropertiesUpdateOperation(this.repository, r, type, lockToken, properties);
        operation.execute(this.client, this.context);
        transaction.register(resource, Transaction.Status.MODIFIED);
    }

    protected abstract void registerResource(Transaction var1, Resource var2, Revision var3);

    protected Resource resolve2(View view, Resource resource, Revision revision, boolean resolve) {
        if (Revision.HEAD.equals(revision)) {
            if (resolve) {
                return this.config.getVersionedResource(resource, view.getHeadRevision());
            }
            return resource;
        }
        return this.config.getVersionedResource(resource, revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Transaction transaction) {
        this.validateTransaction(transaction);
        LOGGER.trace("rolling transaction {} back", (Object)transaction.getId());
        try {
            Resource resource = this.config.getTransactionResource(transaction);
            DeleteOperation operation = new DeleteOperation(this.repository, resource, null);
            operation.execute(this.client, this.context);
        }
        finally {
            transaction.invalidate();
        }
    }

    @Override
    public final void unlock(Resource resource, boolean force) {
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        LOGGER.trace("unlocking {} (force: {})", (Object)resource, (Object)force);
        this.unlock0(this.createView(), resource, force);
    }

    private void unlock0(View view, Resource resource, boolean force) {
        Info info = this.info0(view, resource, view.getHeadRevision(), true, LOCKING);
        if (info == null) {
            throw new SubversionException("Can't resolve: " + resource + '@' + view.getHeadRevision());
        }
        String lockToken = info.getLockToken();
        if (lockToken == null) {
            return;
        }
        UnlockOperation operation = new UnlockOperation(this.repository, resource, lockToken, force);
        operation.execute(this.client, this.context);
    }

    protected void validateRevision(View view, Revision revision) {
        if (Revision.HEAD.equals(revision)) {
            return;
        }
        Revision headRevision = view.getHeadRevision();
        if (headRevision.compareTo(revision) < 0) {
            throw new SubversionException("revision " + revision + " is to new for Transaction/View with head revision " + headRevision);
        }
    }

    protected void validateTransaction(Transaction transaction) {
        Validate.notNull((Object)transaction, (String)"transaction must not be null", (Object[])new Object[0]);
        this.validateView(transaction);
        if (!transaction.isActive()) {
            throw new SubversionException("Transaction invalid: has already been committed or reverted");
        }
    }

    protected void validateView(View view) {
        Validate.notNull((Object)view, (String)"view must not be null", (Object[])new Object[0]);
        UUID transactionRepositoryId = view.getRepositoryId();
        if (!this.repositoryId.equals(transactionRepositoryId)) {
            throw new SubversionException("Transaction/View invalid: does not belong to this repository");
        }
    }

    protected static interface ResourceMapper {
        public Resource getCommitMessageResource(Transaction var1);

        public Resource getCreateTransactionResource();

        public Resource getPrefix();

        public Resource getRegisterResource(Resource var1, Revision var2);

        public Resource getRegisterTransactionResource(Transaction var1);

        public Resource getTransactionResource(Transaction var1);

        public Resource getVersionedResource(Resource var1, Revision var2);

        public Resource getWorkingResource(Transaction var1);
    }
}

