/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.xml;

import de.shadowhunt.subversion.xml.SaxExpression;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractSaxExpressionHandler<V>
extends DefaultHandler {
    private static final SAXParserFactory FACTORY = SAXParserFactory.newInstance();
    private final StringBuilder buffer = new StringBuilder();
    private int depth = 0;
    protected final SaxExpression[] expressions;

    protected AbstractSaxExpressionHandler(SaxExpression ... expressions) {
        this.expressions = expressions;
    }

    @Override
    public final void characters(char[] ch, int start, int length) {
        this.buffer.append(ch, start, length);
    }

    protected void clearText() {
        this.buffer.setLength(0);
    }

    @Override
    public void endDocument() {
        assert (this.depth == 0);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String text = this.getText();
        for (SaxExpression expression : this.expressions) {
            expression.end(uri, localName, this.depth--, text);
        }
        this.clearText();
    }

    protected String getText() {
        return StringEscapeUtils.unescapeXml((String)this.buffer.toString());
    }

    public abstract V getValue();

    public V parse(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = FACTORY.newSAXParser();
        saxParser.parse(inputStream, (DefaultHandler)this);
        return this.getValue();
    }

    @Override
    public void startDocument() {
        this.depth = 0;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.clearText();
        for (SaxExpression expression : this.expressions) {
            expression.start(uri, localName, this.depth++, attributes);
        }
    }

    static {
        FACTORY.setNamespaceAware(true);
        FACTORY.setValidating(false);
    }
}

