/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.xml;

import de.shadowhunt.subversion.xml.SaxExpression;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;

public abstract class AbstractSaxExpression<V>
implements SaxExpression<V> {
    private static final SaxExpression[] NO_CHILDREN = new SaxExpression[0];
    protected final SaxExpression[] children;
    private final QName[] path;
    private int position = 0;

    private static boolean doesElementMatch(QName element, String nameSpaceUri, String localName) {
        return AbstractSaxExpression.doesNameSpaceUriMatch(element, nameSpaceUri) && AbstractSaxExpression.doesLocalNameMatch(element, localName);
    }

    private static boolean doesLocalNameMatch(QName element, String localName) {
        String pLocalName = element.getLocalPart();
        return "*".equals(pLocalName) || pLocalName.equals(localName);
    }

    private static boolean doesNameSpaceUriMatch(QName element, String nameSpaceUri) {
        String pNameSpaceUri = element.getNamespaceURI();
        return "".equals(pNameSpaceUri) || pNameSpaceUri.equals(nameSpaceUri);
    }

    protected AbstractSaxExpression(QName[] path) {
        this(path, NO_CHILDREN);
    }

    protected AbstractSaxExpression(QName[] path, SaxExpression ... children) {
        this.path = Arrays.copyOf(path, path.length);
        this.children = children;
    }

    @Override
    public void clear() {
    }

    @Override
    public final void end(String nameSpaceUri, String localName, int depth, String text) {
        if (depth > this.position || this.position - 1 >= this.path.length) {
            int childDepth = depth - this.position;
            for (SaxExpression child : this.children) {
                child.end(nameSpaceUri, localName, childDepth, text);
            }
            return;
        }
        if (!AbstractSaxExpression.doesElementMatch(this.path[this.position - 1], nameSpaceUri, localName)) {
            return;
        }
        if (this.position == this.path.length) {
            this.processEnd(nameSpaceUri, localName, text);
        }
        --this.position;
    }

    protected void processEnd(String nameSpaceUri, String localName, String text) {
    }

    protected void processStart(String nameSpaceUri, String localName, Attributes attributes) {
    }

    @Override
    public final void reset() {
        this.position = 0;
        for (SaxExpression child : this.children) {
            child.reset();
        }
    }

    public void resetHandler() {
        for (SaxExpression child : this.children) {
            ((AbstractSaxExpression)child).resetHandler();
        }
    }

    @Override
    public final void start(String nameSpaceUri, String localName, int depth, Attributes attributes) {
        if (depth > this.position || this.position >= this.path.length) {
            int childDepth = depth - this.position;
            for (SaxExpression child : this.children) {
                child.start(nameSpaceUri, localName, childDepth, attributes);
            }
            return;
        }
        if (!AbstractSaxExpression.doesElementMatch(this.path[this.position], nameSpaceUri, localName)) {
            return;
        }
        ++this.position;
        if (this.position == this.path.length) {
            this.resetHandler();
            this.processStart(nameSpaceUri, localName, attributes);
        }
    }
}

