/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal.httpv1;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.Writer;
import java.net.URI;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class CheckoutOperation
extends AbstractVoidOperation {
    private final Resource resource;
    private final Resource transaction;

    CheckoutOperation(URI repository, Resource resource, Resource transaction) {
        super(repository);
        this.resource = resource;
        this.transaction = transaction;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("CHECKOUT", uri);
        URI transactionURI = URIUtils.createURI(this.repository, this.transaction);
        StringBuilderWriter body = new StringBuilderWriter();
        try {
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter((Writer)body);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("checkout");
            writer.writeDefaultNamespace("DAV:");
            writer.writeStartElement("activity-set");
            writer.writeStartElement("href");
            writer.writeCharacters(transactionURI.toASCIIString());
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEmptyElement("apply-to-version");
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new SubversionException("could not create request body", e);
        }
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 201 == statusCode;
    }
}

