/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.xml.AbstractSaxExpression;
import de.shadowhunt.subversion.xml.AbstractSaxExpressionHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

final class Resolve {
    private Resource resource = null;
    private Revision revision = null;

    Resolve() {
    }

    static Resolve read(InputStream inputStream) throws IOException {
        Resolve resolve;
        ResolveHandler handler = new ResolveHandler();
        try {
            resolve = (Resolve)handler.parse(inputStream);
        }
        catch (ParserConfigurationException e) {
            throw new SubversionException("Invalid server response: could not parse response", e);
        }
        catch (SAXException e) {
            throw new SubversionException("Invalid server response: could not parse response", e);
        }
        if (resolve == null) {
            throw new SubversionException("Invalid server response: could not parse response");
        }
        return resolve;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resolve other = (Resolve)obj;
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
    }

    public Resource getResource() {
        return this.resource;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
        return result;
    }

    void setResource(Resource resource) {
        this.resource = resource;
    }

    void setRevision(Revision revision) {
        this.revision = revision;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Resolve [resource=");
        builder.append(this.resource);
        builder.append(", revision=");
        builder.append(this.revision);
        builder.append(']');
        return builder.toString();
    }

    private static class ResolveHandler
    extends AbstractSaxExpressionHandler<Resolve> {
        ResolveHandler() {
            super(new ResolveExpression());
        }

        @Override
        public Resolve getValue() {
            return ((ResolveExpression)this.expressions[0]).getValue();
        }
    }

    private static class ResolveExpression
    extends AbstractSaxExpression<Resolve> {
        private static final QName[] PATH = new QName[]{new QName("svn:", "get-locations-report"), new QName("svn:", "location")};
        private Resolve entry = null;

        ResolveExpression() {
            super(PATH);
        }

        @Override
        public Resolve getValue() {
            return this.entry;
        }

        @Override
        protected void processStart(String nameSpaceUri, String localName, Attributes attributes) {
            this.entry = new Resolve();
            String version = attributes.getValue("rev");
            this.entry.setRevision(Revision.create(Integer.parseInt(version)));
            String path = attributes.getValue("path");
            this.entry.setResource(Resource.create(path));
        }

        @Override
        public void resetHandler() {
            super.resetHandler();
            this.entry = null;
        }
    }
}

