/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import de.shadowhunt.subversion.internal.XmlConstants;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class PropertiesSetOperation
extends AbstractVoidOperation {
    private final Info info;
    private final ResourceProperty[] properties;
    private final Resource resource;

    PropertiesSetOperation(URI repository, Resource resource, @Nullable Info info, ResourceProperty[] properties) {
        super(repository);
        this.resource = resource;
        this.info = info;
        this.properties = Arrays.copyOf(properties, properties.length);
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("PROPPATCH", uri);
        if (this.info != null && this.info.isLocked()) {
            URI lockTarget = URIUtils.createURI(this.repository, this.info.getResource());
            request.addHeader("If", '<' + lockTarget.toASCIIString() + "> (<" + this.info.getLockToken() + ">)");
        }
        StringBuilderWriter body = new StringBuilderWriter();
        try {
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter((Writer)body);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("propertyupdate");
            writer.writeDefaultNamespace("DAV:");
            writer.setPrefix("C", XmlConstants.CUSTOM_PROPERTIES_NAMESPACE);
            writer.writeNamespace("C", XmlConstants.CUSTOM_PROPERTIES_NAMESPACE);
            writer.setPrefix("S", XmlConstants.SVN_PROPERTIES_NAMESPACE);
            writer.writeNamespace("S", XmlConstants.SVN_PROPERTIES_NAMESPACE);
            writer.setPrefix("V", "http://subversion.tigris.org/xmlns/dav/");
            writer.writeNamespace("V", "http://subversion.tigris.org/xmlns/dav/");
            writer.writeStartElement("set");
            writer.writeStartElement("prop");
            for (ResourceProperty property : this.properties) {
                String prefix = property.getType().getPrefix();
                writer.writeStartElement(prefix, property.getName());
                writer.writeCharacters(property.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new SubversionException("could not create request body", e);
        }
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 207 == statusCode;
    }
}

