/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Repository;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.Prefix;
import de.shadowhunt.subversion.internal.RepositoryLocator;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.util.ServiceLoader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;

class ProbeServerOperation
extends AbstractOperation<Repository> {
    private static Repository.ProtocolVersion determineVersion(Header ... headers) {
        for (Header header : headers) {
            if (!header.getName().startsWith("SVN")) continue;
            return Repository.ProtocolVersion.HTTP_V2;
        }
        return Repository.ProtocolVersion.HTTP_V1;
    }

    ProbeServerOperation(URI repository) {
        super(repository);
    }

    @Override
    protected HttpUriRequest createRequest() {
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("OPTIONS", this.repository);
        StringBuilderWriter body = new StringBuilderWriter();
        try {
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter((Writer)body);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("options");
            writer.writeDefaultNamespace("DAV:");
            writer.writeEmptyElement("activity-collection-set");
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new SubversionException("could not create request body: " + e.getMessage(), e);
        }
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    public Repository execute(HttpClient client, HttpContext context) {
        Resource prefix;
        Repository.ProtocolVersion version;
        HttpUriRequest request = this.createRequest();
        InputStream in = null;
        try {
            HttpResponse response = client.execute(request, context);
            in = ProbeServerOperation.getContent(response);
            this.check(response);
            version = ProbeServerOperation.determineVersion(response.getAllHeaders());
            prefix = Prefix.read(in, version);
        }
        catch (Exception e) {
            try {
                throw new SubversionException("Could not execute request (" + request + ')', e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        for (RepositoryLocator repositoryLocator : ServiceLoader.load(RepositoryLocator.class)) {
            if (!repositoryLocator.isSupported(version)) continue;
            return repositoryLocator.create(this.repository, prefix, client, context);
        }
        throw new SubversionException("Could not find suitable repository for " + this.repository);
    }

    @Override
    public Repository handleResponse(HttpResponse response) {
        return this.processResponse(response);
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 200 == statusCode;
    }

    @Override
    protected Repository processResponse(HttpResponse response) {
        throw new UnsupportedOperationException();
    }
}

