/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Repository;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.xml.AbstractSaxExpression;
import de.shadowhunt.subversion.xml.AbstractSaxExpressionHandler;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

final class Prefix {
    static Resource read(InputStream inputStream, Repository.ProtocolVersion version) {
        Resource prefix;
        try {
            PrefixHandler handler = new PrefixHandler(version);
            prefix = (Resource)handler.parse(inputStream);
        }
        catch (Exception e) {
            throw new SubversionException("Invalid server response: could not parse response", e);
        }
        if (prefix == null) {
            throw new SubversionException("Invalid server response: could not parse response");
        }
        return prefix;
    }

    private Prefix() {
    }

    private static class PrefixHandler
    extends AbstractSaxExpressionHandler<Resource> {
        PrefixHandler(Repository.ProtocolVersion version) {
            super(new PrefixExpression(version));
        }

        @Override
        public Resource getValue() {
            return ((PrefixExpression)this.expressions[0]).getValue();
        }
    }

    private static class PrefixExpression
    extends AbstractSaxExpression<Resource> {
        private static final QName[] PATH = new QName[]{new QName("DAV:", "options-response"), new QName("DAV:", "activity-collection-set"), new QName("DAV:", "href")};
        private static final Pattern PATH_PATTERN = Pattern.compile("/");
        private Resource prefix = null;
        private final Repository.ProtocolVersion version;

        PrefixExpression(Repository.ProtocolVersion version) {
            super(PATH);
            this.version = version;
        }

        @Override
        public Resource getValue() {
            return this.prefix;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            if (Repository.ProtocolVersion.HTTP_V1 == this.version || Repository.ProtocolVersion.HTTP_V2 == this.version) {
                String[] segments = PATH_PATTERN.split(text);
                this.prefix = Resource.create(segments[segments.length - 2]);
            }
        }

        @Override
        public void resetHandler() {
            super.resetHandler();
            this.prefix = null;
        }
    }
}

