/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Log;
import de.shadowhunt.subversion.Revision;
import java.util.Date;

final class LogImpl
implements Log {
    private String author = null;
    private Date date = null;
    private String message = "";
    private Revision revision = null;

    LogImpl() {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogImpl other = (LogImpl)obj;
        if (this.author == null ? other.author != null : !this.author.equals(other.author)) {
            return false;
        }
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public Date getDate() {
        return new Date(this.date.getTime());
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Revision getRevision() {
        return this.revision;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.author == null ? 0 : this.author.hashCode());
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
        return result;
    }

    void setAuthor(String author) {
        this.author = author;
    }

    void setDate(Date date) {
        this.date = new Date(date.getTime());
    }

    void setMessage(String message) {
        this.message = message;
    }

    void setRevision(Revision revision) {
        this.revision = revision;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Log [author=");
        builder.append(this.author);
        builder.append(", date=");
        builder.append(this.date);
        builder.append(", message=");
        builder.append(this.message);
        builder.append(", revision=");
        builder.append(this.revision);
        builder.append(']');
        return builder.toString();
    }
}

