/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.Writer;
import java.net.URI;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class LockOperation
extends AbstractVoidOperation {
    private final Resource resource;
    private final boolean steal;

    public LockOperation(URI repository, Resource resource, boolean steal) {
        super(repository);
        this.resource = resource;
        this.steal = steal;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("LOCK", uri);
        if (this.steal) {
            request.addHeader("X-SVN-Options", "lock-steal");
        }
        StringBuilderWriter body = new StringBuilderWriter();
        try {
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter((Writer)body);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("lockinfo");
            writer.writeDefaultNamespace("DAV:");
            writer.writeStartElement("lockscope");
            writer.writeEmptyElement("exclusive");
            writer.writeEndElement();
            writer.writeStartElement("locktype");
            writer.writeEmptyElement("write");
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new SubversionException("could not create request body", e);
        }
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 200 == statusCode;
    }
}

