/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Depth;
import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.InfoImpl;
import de.shadowhunt.subversion.internal.InfoImplReader;
import de.shadowhunt.subversion.internal.URIUtils;
import de.shadowhunt.subversion.internal.VersionParser;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class InfoOperation
extends AbstractOperation<Info> {
    private static final String LOCK_OWNER_HEADER = "X-SVN-Lock-Owner";
    private final Resource marker;
    private final VersionParser parser;
    private final Resource resource;

    public InfoOperation(URI repository, Resource resource, VersionParser parser, Resource marker) {
        super(repository);
        this.resource = resource;
        this.parser = parser;
        this.marker = marker;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("PROPFIND", uri);
        request.addHeader("Depth", Depth.EMPTY.value);
        StringBuilderWriter body = new StringBuilderWriter();
        try {
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter((Writer)body);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("propfind");
            writer.writeDefaultNamespace("DAV:");
            writer.writeEmptyElement("allprop");
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new SubversionException("could not create request body", e);
        }
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 207 == statusCode;
    }

    @Override
    protected Info processResponse(HttpResponse response) throws IOException {
        Info info = InfoImplReader.read(InfoOperation.getContent(response), this.parser, this.repository.getPath(), this.marker.getValue());
        if (info.isLocked()) {
            Header header = response.getFirstHeader(LOCK_OWNER_HEADER);
            ((InfoImpl)info).setLockOwner(header.getValue());
        }
        return info;
    }
}

