/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.DateUtils;
import de.shadowhunt.subversion.internal.InfoImpl;
import de.shadowhunt.subversion.internal.VersionParser;
import de.shadowhunt.subversion.internal.XmlConstants;
import de.shadowhunt.subversion.xml.AbstractSaxExpression;
import de.shadowhunt.subversion.xml.AbstractSaxExpressionHandler;
import de.shadowhunt.subversion.xml.SaxExpression;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

final class InfoImplReader {
    static Info read(InputStream in, VersionParser parser, String base, String marker) throws IOException {
        SortedSet<Info> infoSet = InfoImplReader.readAll(in, parser, base, marker);
        if (infoSet.isEmpty()) {
            throw new SubversionException("Invalid server response: expected content is missing");
        }
        return infoSet.first();
    }

    static SortedSet<Info> readAll(InputStream inputStream, VersionParser parser, String base, String marker) throws IOException {
        InfoHandler handler = new InfoHandler(base, marker);
        try {
            return (SortedSet)handler.parse(inputStream);
        }
        catch (ParserConfigurationException e) {
            throw new SubversionException("Invalid server response: could not parse response", e);
        }
        catch (SAXException e) {
            throw new SubversionException("Invalid server response: could not parse response", e);
        }
    }

    private InfoImplReader() {
    }

    private static class StringExpression
    extends AbstractSaxExpression<String> {
        private static final QName PROP = new QName("DAV:", "prop");
        private static final QName PROPSTAT = new QName("DAV:", "propstat");
        private String value = null;

        private static QName[] prefix(QName ... path) {
            QName[] prefixPath = new QName[path.length + 2];
            int i = 0;
            prefixPath[i++] = PROPSTAT;
            prefixPath[i++] = PROP;
            for (QName name : path) {
                prefixPath[i++] = name;
            }
            return prefixPath;
        }

        protected StringExpression(QName ... path) {
            super(StringExpression.prefix(path));
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            this.value = text;
        }

        @Override
        public void resetHandler() {
            this.value = null;
        }
    }

    private static class StatusExpression
    extends AbstractSaxExpression<Void> {
        public static final QName[] PATH = new QName[]{new QName("DAV:", "propstat"), new QName("DAV:", "status")};

        StatusExpression() {
            super(PATH);
        }

        @Override
        public Void getValue() {
            throw new UnsupportedOperationException("no value available");
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            if (!"HTTP/1.1 200 OK".equals(text)) {
                throw new SubversionException("properties are missing");
            }
        }
    }

    private static class ResourceTypeExpression
    extends AbstractSaxExpression<Boolean> {
        private static final QName[] PATH = new QName[]{new QName("DAV:", "propstat"), new QName("DAV:", "prop"), new QName("DAV:", "resourcetype"), new QName("DAV:", "collection")};
        private boolean folder = false;

        protected ResourceTypeExpression() {
            super(PATH);
        }

        @Override
        public Boolean getValue() {
            return this.folder;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            this.folder = true;
        }

        @Override
        public void resetHandler() {
            this.folder = false;
        }
    }

    private static class ResourceExpression
    extends AbstractSaxExpression<Resource> {
        private static final QName[] PATH = new QName[]{new QName("DAV:", "propstat"), new QName("DAV:", "prop"), new QName("DAV:", "checked-in"), new QName("DAV:", "href")};
        private final String base;
        private final String marker;
        private Resource resource = null;

        ResourceExpression(String base, String marker) {
            super(PATH);
            this.base = base;
            this.marker = marker;
        }

        @Override
        public Resource getValue() {
            return this.resource;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            String path = StringUtils.removeStart((String)text, (String)this.base);
            if (path.startsWith(this.marker)) {
                int part = this.marker.length() + 1;
                for (int i = 0; i < 2; ++i) {
                    part = path.indexOf(47, part) + 1;
                }
                this.resource = Resource.create(path.substring(part));
            } else {
                this.resource = Resource.create(path);
            }
        }

        @Override
        public void resetHandler() {
            this.resource = null;
        }
    }

    private static class PropertyExpression
    extends AbstractSaxExpression<ResourceProperty[]> {
        private static final QName[] PATH = new QName[]{new QName("DAV:", "propstat"), new QName("DAV:", "prop"), new QName("", "*")};
        private Set<ResourceProperty> properties = new TreeSet<ResourceProperty>(ResourceProperty.TYPE_NAME_COMPARATOR);

        PropertyExpression() {
            super(PATH);
        }

        @Override
        public void clear() {
            this.properties = new TreeSet<ResourceProperty>(ResourceProperty.TYPE_NAME_COMPARATOR);
        }

        @Override
        public ResourceProperty[] getValue() {
            ResourceProperty[] resourceProperties = new ResourceProperty[this.properties.size()];
            int i = 0;
            for (ResourceProperty property : this.properties) {
                resourceProperties[i++] = property;
            }
            return resourceProperties;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            if (XmlConstants.CUSTOM_PROPERTIES_NAMESPACE.equals(nameSpaceUri)) {
                this.properties.add(new ResourceProperty(ResourceProperty.Type.CUSTOM, localName, text));
                return;
            }
            if (XmlConstants.SVN_PROPERTIES_NAMESPACE.equals(nameSpaceUri)) {
                this.properties.add(new ResourceProperty(ResourceProperty.Type.SVN, localName, text));
                return;
            }
        }
    }

    private static class InfoHandler
    extends AbstractSaxExpressionHandler<SortedSet<Info>> {
        InfoHandler(String base, String marker) {
            super(new InfoExpression(base, marker));
        }

        @Override
        public SortedSet<Info> getValue() {
            return ((InfoExpression)this.expressions[0]).getValue();
        }
    }

    private static class InfoExpression
    extends AbstractSaxExpression<SortedSet<Info>> {
        private static final QName[] PATH = new QName[]{new QName("DAV:", "multistatus"), new QName("DAV:", "response")};
        private final SortedSet<Info> entries = new TreeSet<Info>(Info.RESOURCE_COMPARATOR);

        private static SaxExpression[] createExpressions(String base, String marker) {
            return new SaxExpression[]{new StringExpression(new QName("DAV:", "creationdate")), new ResourceTypeExpression(), new StringExpression(new QName("DAV:", "getlastmodified")), new StringExpression(new QName("DAV:", "lockdiscovery"), new QName("DAV:", "activelock"), new QName("DAV:", "locktoken"), new QName("DAV:", "href")), new StringExpression(new QName("http://subversion.tigris.org/xmlns/dav/", "md5-checksum")), new PropertyExpression(), new StringExpression(new QName("http://subversion.tigris.org/xmlns/dav/", "repository-uuid")), new ResourceExpression(base, marker), new StringExpression(new QName("DAV:", "version-name")), new StatusExpression()};
        }

        InfoExpression(String base, String marker) {
            super(PATH, InfoExpression.createExpressions(base, marker));
        }

        @Override
        public SortedSet<Info> getValue() {
            return this.entries;
        }

        @Override
        protected void processEnd(String nameSpaceUri, String localName, String text) {
            InfoImpl info = new InfoImpl();
            info.setCreationDate(DateUtils.parseCreatedDate(((StringExpression)this.children[0]).getValue()));
            info.setDirectory(((ResourceTypeExpression)this.children[1]).getValue());
            info.setLastModifiedDate(DateUtils.parseLastModifiedDate(((StringExpression)this.children[2]).getValue()));
            info.setLockToken(((StringExpression)this.children[3]).getValue());
            info.setMd5(((StringExpression)this.children[4]).getValue());
            info.setProperties(((PropertyExpression)this.children[5]).getValue());
            info.setRepositoryId(UUID.fromString(((StringExpression)this.children[6]).getValue()));
            info.setResource(((ResourceExpression)this.children[7]).getValue());
            int revision = Integer.parseInt(((StringExpression)this.children[8]).getValue());
            info.setRevision(Revision.create(revision));
            this.entries.add(info);
            this.children[5].clear();
        }
    }
}

