/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.Revision;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;

final class InfoImpl
implements Info {
    private static final ResourceProperty[] EMPTY = new ResourceProperty[0];
    private ResourceProperty[] properties = EMPTY;
    private Date creationDate = null;
    private boolean directory = false;
    private Date lastModifiedDate = null;
    private String lockOwner = null;
    private String lockToken = null;
    private String md5 = null;
    private UUID repositoryId = null;
    private Resource resource = null;
    private Revision revision = null;

    InfoImpl() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InfoImpl)) {
            return false;
        }
        InfoImpl info = (InfoImpl)o;
        if (!this.repositoryId.equals(info.repositoryId)) {
            return false;
        }
        if (!this.resource.equals(info.resource)) {
            return false;
        }
        return this.revision.equals(info.revision);
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate == null ? null : new Date(this.creationDate.getTime());
    }

    @Override
    public Date getLastModifiedDate() {
        return this.lastModifiedDate == null ? null : new Date(this.lastModifiedDate.getTime());
    }

    @Override
    public String getLockOwner() {
        return this.lockOwner;
    }

    @Override
    public String getLockToken() {
        return this.lockToken;
    }

    @Override
    public String getMd5() {
        return this.md5;
    }

    @Override
    public ResourceProperty[] getProperties() {
        return Arrays.copyOf(this.properties, this.properties.length);
    }

    @Override
    public UUID getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public Revision getRevision() {
        return this.revision;
    }

    public int hashCode() {
        int result = this.repositoryId.hashCode();
        result = 31 * result + this.resource.hashCode();
        result = 31 * result + this.revision.hashCode();
        return result;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public boolean isFile() {
        return !this.directory;
    }

    @Override
    public boolean isLocked() {
        return this.lockToken != null;
    }

    void setCreationDate(@Nullable Date creationDate) {
        this.creationDate = creationDate;
    }

    void setDirectory(boolean directory) {
        this.directory = directory;
    }

    void setLastModifiedDate(@Nullable Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    void setLockOwner(@Nullable String lockOwner) {
        this.lockOwner = lockOwner;
    }

    void setLockToken(@Nullable String lockToken) {
        this.lockToken = lockToken;
    }

    void setMd5(@Nullable String md5) {
        this.md5 = md5;
    }

    void setProperties(@Nullable ResourceProperty[] properties) {
        this.properties = properties == null || properties.length == 0 ? EMPTY : Arrays.copyOf(properties, properties.length);
    }

    void setRepositoryId(UUID repositoryId) {
        this.repositoryId = repositoryId;
    }

    void setResource(Resource resource) {
        this.resource = resource;
    }

    void setRevision(Revision revision) {
        this.revision = revision;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Info [directory=");
        builder.append(this.directory);
        builder.append(", lockOwner=");
        builder.append(this.lockOwner);
        builder.append(", lockToken=");
        builder.append(this.lockToken);
        builder.append(", md5=");
        builder.append(this.md5);
        builder.append(", properties=");
        builder.append(Arrays.toString(this.properties));
        builder.append(", repositoryId=");
        builder.append(this.repositoryId);
        builder.append(", resource=");
        builder.append(this.resource);
        builder.append(", revision=");
        builder.append(this.revision);
        builder.append(']');
        return builder.toString();
    }
}

