/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

class DownloadOperation
extends AbstractOperation<InputStream> {
    private final Resource resource;

    DownloadOperation(URI repository, Resource resource) {
        super(repository);
        this.resource = resource;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        return new HttpGet(uri);
    }

    @Override
    public InputStream execute(HttpClient client, HttpContext context) {
        HttpUriRequest request = this.createRequest();
        InputStream in = null;
        try {
            HttpResponse response = client.execute(request, context);
            in = DownloadOperation.getContent(response);
            this.check(response);
            return in;
        }
        catch (Exception e) {
            IOUtils.closeQuietly(in);
            throw new SubversionException("Could not execute request (" + request + ')', e);
        }
    }

    @Override
    public InputStream handleResponse(HttpResponse response) {
        return this.processResponse(response);
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 200 == statusCode;
    }

    @Override
    protected InputStream processResponse(HttpResponse response) {
        throw new UnsupportedOperationException();
    }
}

