/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.URIUtils;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;

class DeleteOperation
extends AbstractVoidOperation {
    private final Info info;
    private final Resource resource;

    public DeleteOperation(URI repository, Resource resource, @Nullable Info info) {
        super(repository);
        this.resource = resource;
        this.info = info;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.createURI(this.repository, this.resource);
        HttpDelete request = new HttpDelete(uri);
        if (this.info != null && this.info.isLocked()) {
            URI lockTarget = URIUtils.createURI(this.repository, this.info.getResource());
            request.addHeader("If", '<' + lockTarget.toASCIIString() + "> (<" + this.info.getLockToken() + ">)");
        }
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 204 == statusCode;
    }
}

