/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

final class DateUtils {
    private static final String CREATED_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String LAST_MODIFIED_PATTERN = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final TimeZone ZULU = TimeZone.getTimeZone("ZULU");

    static Date parseCreatedDate(String date) {
        if ('Z' != date.charAt(date.length() - 1)) {
            throw new IllegalArgumentException("date '" + date + "'is not in Zulu timezone");
        }
        int index = date.indexOf(46);
        String time = index > 0 ? date.substring(0, index + 4) : date;
        SimpleDateFormat dateFormat = new SimpleDateFormat(CREATED_PATTERN, Locale.US);
        try {
            dateFormat.setTimeZone(ZULU);
            return dateFormat.parse(time);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("given date '" + date + "' can not be parsed", e);
        }
    }

    static Date parseLastModifiedDate(String date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(LAST_MODIFIED_PATTERN, Locale.US);
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("given date '" + date + "' can not be parsed", e);
        }
    }

    private DateUtils() {
    }
}

