/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion;

import java.util.Comparator;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.Validate;

@Immutable
public final class ResourceProperty {
    public static final Comparator<ResourceProperty> TYPE_NAME_COMPARATOR = new Comparator<ResourceProperty>(){

        @Override
        public int compare(ResourceProperty rp1, ResourceProperty rp2) {
            Validate.notNull((Object)rp1, (String)"rp1 must not be null", (Object[])new Object[0]);
            Validate.notNull((Object)rp2, (String)"rp2 must not be null", (Object[])new Object[0]);
            int result = rp1.getType().compareTo(rp2.getType());
            if (result != 0) {
                return result;
            }
            return rp1.getName().compareTo(rp2.getName());
        }
    };
    private final String name;
    private final Type type;
    private final String value;

    public ResourceProperty(Type type, String name, String value) {
        Validate.notNull((Object)((Object)type), (String)"type must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)name, (String)"name must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)value, (String)"value must not be null", (Object[])new Object[0]);
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceProperty)) {
            return false;
        }
        ResourceProperty that = (ResourceProperty)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceProperty [type=");
        builder.append((Object)this.type);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", value=");
        builder.append(this.value);
        builder.append(']');
        return builder.toString();
    }

    public static enum Type {
        CUSTOM("http://subversion.tigris.org/xmlns/custom/"),
        SVN("http://subversion.tigris.org/xmlns/svn/");

        private final String prefix;

        private Type(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

