/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion;

import de.shadowhunt.subversion.Repository;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.SubversionException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.Validate;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;

@ThreadSafe
public abstract class RepositoryFactory {
    private static final String DEFAULT_FRAGMENT = null;
    private static final String DEFAULT_QUERY = null;
    private static final String DEFAULT_USER_INFO = null;

    public static RepositoryFactory getInstance() throws SubversionException {
        Iterator<RepositoryFactory> i$ = ServiceLoader.load(RepositoryFactory.class).iterator();
        if (i$.hasNext()) {
            RepositoryFactory factory = i$.next();
            return factory;
        }
        throw new SubversionException("Can not find a RepositoryFactory");
    }

    private static URI sanitise(URI uri, Resource path) {
        try {
            return new URI(uri.getScheme(), DEFAULT_USER_INFO, uri.getHost(), uri.getPort(), path.getValue(), DEFAULT_QUERY, DEFAULT_FRAGMENT);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public final Repository createRepository(URI repository, HttpClient client, HttpContext context) throws SubversionException {
        Validate.notNull((Object)repository, (String)"repository must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)client, (String)"client must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)context, (String)"context must not be null", (Object[])new Object[0]);
        URI saneUri = RepositoryFactory.sanitise(repository, Resource.create(repository.getPath()));
        return this.createRepository0(saneUri, client, context);
    }

    protected abstract Repository createRepository0(URI var1, HttpClient var2, HttpContext var3) throws SubversionException;

    public Repository probeRepository(URI repository, HttpClient client, HttpContext context) throws SubversionException {
        Validate.notNull((Object)repository, (String)"repository must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)client, (String)"client must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)context, (String)"context must not be null", (Object[])new Object[0]);
        Resource path = Resource.create(repository.getPath());
        while (true) {
            try {
                URI saneUri = RepositoryFactory.sanitise(repository, path);
                return this.createRepository0(saneUri, client, context);
            }
            catch (SubversionException e) {
                int httpStatusCode = e.getHttpStatusCode();
                if (httpStatusCode > 0 && httpStatusCode != 404) {
                    throw e;
                }
                if (!Resource.ROOT.equals(path)) {
                    path = path.getParent();
                    continue;
                }
                throw new SubversionException("Could not find repository in path: " + repository.getPath());
            }
            break;
        }
    }
}

