/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion;

import de.shadowhunt.subversion.Depth;
import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Log;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.Transaction;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface Repository {
    public void add(Transaction var1, Resource var2, boolean var3, InputStream var4) throws SubversionException;

    public void commit(Transaction var1, @Nullable String var2) throws SubversionException;

    public void copy(Transaction var1, Resource var2, Revision var3, Resource var4, boolean var5) throws SubversionException;

    public Transaction createTransaction() throws SubversionException;

    public void delete(Transaction var1, Resource var2) throws SubversionException;

    public InputStream download(Resource var1, Revision var2) throws SubversionException;

    public URI downloadURI(Resource var1, Revision var2) throws SubversionException;

    public boolean exists(Resource var1, Revision var2) throws SubversionException;

    public URI getBaseUri();

    public ProtocolVersion getProtocolVersion();

    public UUID getRepositoryId();

    public Info info(Resource var1, Revision var2) throws SubversionException;

    public Set<Info> list(Resource var1, Revision var2, Depth var3) throws SubversionException;

    public void lock(Resource var1, boolean var2) throws SubversionException;

    public List<Log> log(Resource var1, Revision var2, Revision var3, int var4) throws SubversionException;

    public void mkdir(Transaction var1, Resource var2, boolean var3) throws SubversionException;

    public void move(Transaction var1, Resource var2, Resource var3, boolean var4) throws SubversionException;

    public void propertiesDelete(Transaction var1, Resource var2, ResourceProperty ... var3) throws SubversionException;

    public void propertiesSet(Transaction var1, Resource var2, ResourceProperty ... var3) throws SubversionException;

    public void rollback(Transaction var1) throws SubversionException;

    public void unlock(Resource var1, boolean var2) throws SubversionException;

    public static enum ProtocolVersion {
        HTTP_V1,
        HTTP_V2;

    }
}

